/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeoutService {
    private static final ThreadFactory threadFactory = new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = this.count.incrementAndGet();
            String threadName = "TimeoutService-" + threadNumber;
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(true);
            return thread;
        }
    };
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(20, threadFactory);

    public static final TimeoutToken addTimeoutHandler(long runTime, Runnable handler) {
        TimeoutToken token = new TimeoutToken();
        token.handler = handler;
        long delay = runTime - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        scheduler.schedule(token, delay, TimeUnit.MILLISECONDS);
        return token;
    }

    public static final void cancelTimeoutHandler(TimeoutToken token) {
        token.cancelled = true;
    }

    public static class TimeoutToken
    implements Runnable {
        private Runnable handler;
        private boolean cancelled = false;

        @Override
        public void run() {
            if (!this.cancelled) {
                this.handler.run();
            }
        }
    }
}

