/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.ThrowsSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeParameter;
import aQute.bnd.signatures.TypeVariableSignature;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.util.FileUtils;

public class SignatureRuleImpl
implements SignatureRule {
    private final Logger logger;
    private final Map<String, BundleData> bundleUpdates;
    private final Map<String, Map<String, String>> specificTextUpdates;
    private final Map<Pattern, Map<String, String>> wildCardTextUpdates;
    private final Map<String, String> directStrings;
    private final Map<String, Map<String, String>> perClassConstantStrings;
    protected final Map<String, String> dottedPackageRenames;
    protected final Map<String, String> slashedPackageRenames;
    protected final Map<String, String> packageVersions;
    private final Map<String, String> changedBinaryTypes;
    private final Set<String> unchangedBinaryTypes;
    private final Set<String> unchangedDescriptors;
    private final Map<String, String> changedDescriptors;
    private final Set<String> unchangedSignatures;
    private final Map<String, String> changedSignatures;

    public SignatureRuleImpl(Logger logger, Map<String, String> renames, Map<String, String> versions, Map<String, BundleData> bundleUpdates, Map<String, Map<String, String>> masterTextUpdates, Map<String, String> directStrings, Map<String, Map<String, String>> perClassConstant) {
        Map<String, String> useBinaryRenames;
        Map<String, String> useRenames;
        this.logger = logger;
        if (renames == null || renames.isEmpty()) {
            useRenames = Collections.emptyMap();
            useBinaryRenames = Collections.emptyMap();
        } else {
            useRenames = new HashMap(renames.size());
            useBinaryRenames = new HashMap(renames.size());
            for (Map.Entry<String, String> renameEntry : renames.entrySet()) {
                String initialName = renameEntry.getKey();
                String finalName = renameEntry.getValue();
                useRenames.put(initialName, finalName);
                String initialBinaryName = initialName.replace('.', '/');
                String finalBinaryName = finalName.replace('.', '/');
                useBinaryRenames.put(initialBinaryName, finalBinaryName);
            }
        }
        this.dottedPackageRenames = useRenames;
        this.slashedPackageRenames = useBinaryRenames;
        Map<Object, Object> useVersions = versions != null && !versions.isEmpty() ? new HashMap<String, String>(versions) : Collections.emptyMap();
        this.packageVersions = useVersions;
        Map<Object, Object> useBundleUpdates = bundleUpdates != null && !bundleUpdates.isEmpty() ? new HashMap<String, BundleData>(bundleUpdates) : Collections.emptyMap();
        this.bundleUpdates = useBundleUpdates;
        if (masterTextUpdates != null && !masterTextUpdates.isEmpty()) {
            HashMap<String, Map<String, String>> useSpecificTextUpdates = new HashMap<String, Map<String, String>>();
            HashMap<Pattern, Map<String, String>> useWildCardTextUpdates = new HashMap<Pattern, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : masterTextUpdates.entrySet()) {
                String matchesFileName = entry.getKey();
                Map<String, String> substitutions = entry.getValue();
                if (matchesFileName.indexOf(63) != -1 || matchesFileName.indexOf(42) != -1) {
                    matchesFileName = matchesFileName.replace("?", ".?").replace("*", ".*?");
                    Pattern matchPattern = Pattern.compile(matchesFileName);
                    useWildCardTextUpdates.put(matchPattern, substitutions);
                    continue;
                }
                useSpecificTextUpdates.put(matchesFileName, substitutions);
            }
            this.specificTextUpdates = useSpecificTextUpdates;
            this.wildCardTextUpdates = useWildCardTextUpdates;
        } else {
            this.specificTextUpdates = null;
            this.wildCardTextUpdates = null;
        }
        Map<Object, Object> useDirectStrings = directStrings == null || directStrings.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(directStrings);
        this.directStrings = useDirectStrings;
        this.unchangedBinaryTypes = new HashSet<String>();
        this.changedBinaryTypes = new HashMap<String, String>();
        this.unchangedSignatures = new HashSet<String>();
        this.changedSignatures = new HashMap<String, String>();
        this.unchangedDescriptors = new HashSet<String>();
        this.changedDescriptors = new HashMap<String, String>();
        Map<Object, Object> perClass = perClassConstant == null || perClassConstant.isEmpty() ? Collections.emptyMap() : new HashMap<String, Map<String, String>>(perClassConstant);
        this.perClassConstantStrings = perClass;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void debug(String message, Object ... parms) {
        this.getLogger().log(Level.FINE, message, parms);
    }

    @Override
    public BundleData getBundleUpdate(String symbolicName) {
        return this.bundleUpdates.get(symbolicName);
    }

    public Map<String, Map<String, String>> getSpecificTextUpdates() {
        return this.specificTextUpdates;
    }

    public Map<Pattern, Map<String, String>> getWildCardTextUpdates() {
        return this.wildCardTextUpdates;
    }

    @Override
    public String getDirectString(String initialValue) {
        return this.directStrings.get(initialValue);
    }

    @Override
    public String getConstantString(String initialValue, String clazz) {
        Map<String, String> m = this.perClassConstantStrings.get(clazz);
        if (m == null) {
            return null;
        }
        String full = m.get(initialValue);
        if (full != null) {
            this.debug("Per class direct replacement:[%s], %s=> %s", clazz, initialValue, full);
            return full;
        }
        String transformedString = initialValue;
        boolean transformed = false;
        for (String k : m.keySet()) {
            if (!transformedString.contains(k)) continue;
            transformedString = transformedString.replace(k, m.get(k));
            this.debug("Per class token replacement:[%s], key=%s, initialValue=%s", clazz, k, initialValue);
            transformed = true;
        }
        if (transformed) {
            this.debug("Per class token replacement, done:[%s] %s", clazz, transformedString);
            return transformedString;
        }
        return null;
    }

    @Override
    public Map<String, String> getPackageRenames() {
        return this.dottedPackageRenames;
    }

    @Override
    public Map<String, String> getPackageVersions() {
        return this.packageVersions;
    }

    @Override
    public String replacePackage(String initialName) {
        return this.dottedPackageRenames.getOrDefault(initialName, null);
    }

    @Override
    public String replaceBinaryPackage(String initialName) {
        String finalName = this.slashedPackageRenames.getOrDefault(initialName, null);
        return finalName;
    }

    @Override
    public String replacePackages(String text) {
        return this.replacePackages(text, this.dottedPackageRenames);
    }

    @Override
    public String replacePackages(String text, Map<String, String> packageRenames) {
        String initialText = text;
        for (Map.Entry<String, String> renameEntry : packageRenames.entrySet()) {
            int matchStart;
            String key = renameEntry.getKey();
            int keyLen = key.length();
            boolean matchSubpackages = SignatureRuleImpl.containsWildcard(key);
            if (matchSubpackages) {
                key = SignatureRuleImpl.stripWildcard(key);
            }
            int textLimit = text.length() - keyLen;
            int lastMatchEnd = 0;
            while (lastMatchEnd <= textLimit && (matchStart = text.indexOf(key, lastMatchEnd)) != -1) {
                if (!SignatureRuleImpl.isTruePackageMatch(text, matchStart, keyLen, matchSubpackages)) {
                    lastMatchEnd = matchStart + keyLen;
                    continue;
                }
                String value = renameEntry.getValue();
                int valueLen = value.length();
                String head = text.substring(0, matchStart);
                String tail = text.substring(matchStart + keyLen);
                text = head + value + tail;
                lastMatchEnd = matchStart + valueLen;
                textLimit += valueLen - keyLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    public static boolean isTruePackageMatch(String text, int matchStart, int keyLen, boolean matchSubpackages) {
        char charBeforeMatch;
        int textLength = text.length();
        if (matchStart > 0 && (Character.isJavaIdentifierPart(charBeforeMatch = text.charAt(matchStart - 1)) || charBeforeMatch == '.')) {
            return false;
        }
        int matchEnd = matchStart + keyLen;
        if (textLength > matchEnd) {
            char charAfterSeparator;
            char charAfterMatch = text.charAt(matchEnd);
            if (Character.isJavaIdentifierPart(charAfterMatch)) {
                return false;
            }
            if (!(matchSubpackages || charAfterMatch != '.' && charAfterMatch != '/' || textLength <= matchEnd + 1 || !Character.isLowerCase(charAfterSeparator = text.charAt(matchEnd + 1)) && !Character.isDigit(charAfterSeparator))) {
                return false;
            }
        }
        return true;
    }

    public static boolean containsWildcard(String key) {
        return key.endsWith(".*");
    }

    public static String stripWildcard(String key) {
        if (key.endsWith(".*")) {
            key = key.substring(0, key.length() - 2);
        }
        return key;
    }

    public static boolean matches(Pattern p, CharSequence input) {
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public Map<String, String> getTextSubstitutions(String inputFileName) {
        String simpleFileName = FileUtils.getFileNameFromFullyQualifiedFileName(inputFileName);
        Map<String, String> specificUpdates = this.getSpecificTextUpdates().get(simpleFileName);
        if (specificUpdates != null) {
            return specificUpdates;
        }
        for (Map.Entry<Pattern, Map<String, String>> wildcardEntry : this.getWildCardTextUpdates().entrySet()) {
            if (!SignatureRuleImpl.matches(wildcardEntry.getKey(), simpleFileName)) continue;
            return wildcardEntry.getValue();
        }
        return null;
    }

    public String replaceText(String inputFileName, String text) {
        Map<String, String> substitutions = this.getTextSubstitutions(inputFileName);
        if (substitutions == null) {
            throw new IllegalStateException("Input [ " + inputFileName + " ] selected for TEXT transformation, but found no substitutions");
        }
        String initialText = text;
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            int matchStart;
            int valueLen;
            String key = entry.getKey();
            int keyLen = key.length();
            int lastMatchEnd = 0;
            for (int textLimit = text.length() - keyLen; lastMatchEnd <= textLimit && (matchStart = text.indexOf(key, lastMatchEnd)) != -1; textLimit += valueLen - keyLen) {
                String value = entry.getValue();
                valueLen = value.length();
                String head = text.substring(0, matchStart);
                String tail = text.substring(matchStart + keyLen);
                text = head + value + tail;
                lastMatchEnd = matchStart + valueLen;
            }
        }
        if (initialText == text) {
            return null;
        }
        return text;
    }

    @Override
    public String transformConstantAsBinaryType(String inputConstant) {
        return this.transformConstantAsBinaryType(inputConstant, false);
    }

    @Override
    public String transformConstantAsBinaryType(String inputConstant, boolean allowSimpleSubstitution) {
        try {
            return this.transformBinaryType(inputConstant, allowSimpleSubstitution);
        }
        catch (Throwable th) {
            this.debug("Failed to parse constant as resource reference [ {} ]: {}", inputConstant, th.getMessage());
            return null;
        }
    }

    @Override
    public String transformBinaryType(String inputName) {
        return this.transformBinaryType(inputName, false);
    }

    protected String transformBinaryType(String inputName, boolean allowSimpleSubstitution) {
        if (this.unchangedBinaryTypes.contains(inputName)) {
            return null;
        }
        String outputName = this.changedBinaryTypes.get(inputName);
        if (outputName != null) {
            return outputName;
        }
        char c = inputName.charAt(0);
        if (c == '[' || c == 'L' && inputName.charAt(inputName.length() - 1) == ';') {
            Object inputSignature = JavaTypeSignature.of(inputName.replace('$', '.'));
            JavaTypeSignature outputSignature = this.transform((JavaTypeSignature)inputSignature);
            if (outputSignature != null) {
                outputName = outputSignature.toString().replace('.', '$');
            }
        } else {
            String inputPackage;
            String outputPackage;
            int lastSlashOffset = inputName.lastIndexOf(47);
            if (lastSlashOffset != -1 && (outputPackage = this.replaceBinaryPackage(inputPackage = inputName.substring(0, lastSlashOffset))) != null) {
                outputName = outputPackage + inputName.substring(lastSlashOffset);
            }
        }
        if (outputName == null && allowSimpleSubstitution) {
            outputName = this.replacePackages(inputName, this.slashedPackageRenames);
        }
        if (outputName == null) {
            this.unchangedBinaryTypes.add(inputName);
        } else {
            this.changedBinaryTypes.put(inputName, outputName);
        }
        return outputName;
    }

    @Override
    public String transformConstantAsDescriptor(String inputConstant) {
        return this.transformConstantAsDescriptor(inputConstant, false);
    }

    @Override
    public String transformConstantAsDescriptor(String inputConstant, boolean allowSimpleSubstitution) {
        try {
            return this.transformDescriptor(inputConstant, allowSimpleSubstitution);
        }
        catch (Throwable th) {
            this.debug("Failed to parse constant as descriptor [ {} ]: {}", inputConstant, th.getMessage());
            return null;
        }
    }

    @Override
    public String transformDescriptor(String inputDescriptor) {
        return this.transformDescriptor(inputDescriptor, false);
    }

    @Override
    public String transformDescriptor(String inputDescriptor, boolean allowSimpleSubstitution) {
        String inputSignature;
        String outputSignature;
        if (this.unchangedDescriptors.contains(inputDescriptor)) {
            return null;
        }
        String outputDescriptor = this.changedDescriptors.get(inputDescriptor);
        if (outputDescriptor != null) {
            return outputDescriptor;
        }
        char c = inputDescriptor.charAt(0);
        if (c == '(') {
            String inputSignature2 = inputDescriptor.replace('$', '.');
            String outputSignature2 = this.transform(inputSignature2, SignatureRule.SignatureType.METHOD);
            if (outputSignature2 != null) {
                outputDescriptor = outputSignature2.replace('.', '$');
            }
        } else if ((c == '[' || c == 'L' && inputDescriptor.charAt(inputDescriptor.length() - 1) == ';') && (outputSignature = this.transform(inputSignature = inputDescriptor.replace('$', '.'), SignatureRule.SignatureType.FIELD)) != null) {
            outputDescriptor = outputSignature.replace('.', '$');
        }
        if (outputDescriptor == null && allowSimpleSubstitution) {
            outputDescriptor = this.replacePackages(inputDescriptor, this.dottedPackageRenames);
        }
        if (outputDescriptor == null) {
            this.unchangedDescriptors.add(inputDescriptor);
        } else {
            this.changedDescriptors.put(inputDescriptor, outputDescriptor);
        }
        return outputDescriptor;
    }

    @Override
    public String transform(String input, SignatureRule.SignatureType signatureType) {
        if (this.unchangedSignatures.contains(input)) {
            return null;
        }
        String output = this.changedSignatures.get(input);
        if (output != null) {
            return output;
        }
        if (signatureType == SignatureRule.SignatureType.CLASS) {
            ClassSignature inputSignature = ClassSignature.of(input);
            ClassSignature outputSignature = this.transform(inputSignature);
            if (outputSignature != null) {
                output = outputSignature.toString();
            }
        } else if (signatureType == SignatureRule.SignatureType.FIELD) {
            FieldSignature inputSignature = FieldSignature.of(input);
            FieldSignature outputSignature = this.transform(inputSignature);
            if (outputSignature != null) {
                output = outputSignature.toString();
            }
        } else if (signatureType == SignatureRule.SignatureType.METHOD) {
            MethodSignature inputSignature = MethodSignature.of(input);
            MethodSignature outputSignature = this.transform(inputSignature);
            if (outputSignature != null) {
                output = outputSignature.toString();
            }
        } else {
            throw new IllegalArgumentException("Signature [ " + input + " ] uses unknown type [ " + (Object)((Object)signatureType) + " ]");
        }
        if (output == null) {
            this.unchangedSignatures.add(input);
        } else {
            this.changedSignatures.put(input, output);
        }
        return output;
    }

    @Override
    public ClassSignature transform(ClassSignature classSignature) {
        TypeParameter[] inputTypes = classSignature.typeParameters;
        TypeParameter[] outputTypes = null;
        for (int parmNo = 0; parmNo < inputTypes.length; ++parmNo) {
            TypeParameter inputType = inputTypes[parmNo];
            TypeParameter outputType = this.transform(inputType);
            if (outputType == null) continue;
            if (outputTypes == null) {
                outputTypes = (TypeParameter[])inputTypes.clone();
            }
            outputTypes[parmNo] = outputType;
        }
        ClassTypeSignature inputSuperClass = classSignature.superClass;
        ClassTypeSignature outputSuperClass = this.transform(inputSuperClass);
        ClassTypeSignature[] inputInterfaces = classSignature.superInterfaces;
        ClassTypeSignature[] outputInterfaces = null;
        for (int interfaceNo = 0; interfaceNo < inputInterfaces.length; ++interfaceNo) {
            ClassTypeSignature inputInterface = inputInterfaces[interfaceNo];
            ClassTypeSignature outputInterface = this.transform(inputInterface);
            if (outputInterface == null) continue;
            if (outputInterfaces == null) {
                outputInterfaces = (ClassTypeSignature[])inputInterfaces.clone();
            }
            outputInterfaces[interfaceNo] = outputInterface;
        }
        if (outputTypes == null && outputSuperClass == null && outputInterfaces == null) {
            return null;
        }
        return new ClassSignature(outputTypes == null ? inputTypes : outputTypes, outputSuperClass == null ? inputSuperClass : outputSuperClass, outputInterfaces == null ? inputInterfaces : outputInterfaces);
    }

    @Override
    public FieldSignature transform(FieldSignature fieldSignature) {
        ReferenceTypeSignature inputType = fieldSignature.type;
        ReferenceTypeSignature outputType = this.transform(inputType);
        if (outputType == null) {
            return null;
        }
        return new FieldSignature(outputType);
    }

    @Override
    public MethodSignature transform(MethodSignature methodSignature) {
        TypeParameter[] inputTypeParms = methodSignature.typeParameters;
        TypeParameter[] outputTypeParms = null;
        for (int parmNo = 0; parmNo < inputTypeParms.length; ++parmNo) {
            TypeParameter inputTypeParm = inputTypeParms[parmNo];
            TypeParameter outputTypeParm = this.transform(inputTypeParm);
            if (outputTypeParm == null) continue;
            if (outputTypeParms == null) {
                outputTypeParms = (TypeParameter[])inputTypeParms.clone();
            }
            outputTypeParms[parmNo] = outputTypeParm;
        }
        JavaTypeSignature[] inputParmTypes = methodSignature.parameterTypes;
        JavaTypeSignature[] outputParmTypes = null;
        for (int parmNo = 0; parmNo < inputParmTypes.length; ++parmNo) {
            JavaTypeSignature inputParmType = inputParmTypes[parmNo];
            JavaTypeSignature outputParmType = this.transform(inputParmType);
            if (outputParmType == null) continue;
            if (outputParmTypes == null) {
                outputParmTypes = (JavaTypeSignature[])inputParmTypes.clone();
            }
            outputParmTypes[parmNo] = outputParmType;
        }
        Result inputResult = methodSignature.resultType;
        Result outputResult = this.transform(inputResult);
        ThrowsSignature[] inputThrows = methodSignature.throwTypes;
        ThrowsSignature[] outputThrows = null;
        for (int throwNo = 0; throwNo < inputThrows.length; ++throwNo) {
            ThrowsSignature inputThrow = inputThrows[throwNo];
            ThrowsSignature outputThrow = this.transform(inputThrow);
            if (outputThrow == null) continue;
            if (outputThrows == null) {
                outputThrows = (ThrowsSignature[])inputThrows.clone();
            }
            outputThrows[throwNo] = outputThrow;
        }
        if (outputTypeParms == null && outputParmTypes == null && outputResult == null && outputThrows == null) {
            return null;
        }
        return new MethodSignature(outputTypeParms == null ? inputTypeParms : outputTypeParms, outputParmTypes == null ? inputParmTypes : outputParmTypes, outputResult == null ? inputResult : outputResult, outputThrows == null ? inputThrows : outputThrows);
    }

    @Override
    public Result transform(Result type) {
        if (type instanceof JavaTypeSignature) {
            return this.transform((JavaTypeSignature)type);
        }
        return null;
    }

    @Override
    public ThrowsSignature transform(ThrowsSignature type) {
        if (type instanceof ClassTypeSignature) {
            return this.transform((ClassTypeSignature)type);
        }
        return null;
    }

    @Override
    public ArrayTypeSignature transform(ArrayTypeSignature inputType) {
        JavaTypeSignature inputComponent = inputType.component;
        int componentDepth = 1;
        while (inputComponent instanceof ArrayTypeSignature) {
            ++componentDepth;
            inputComponent = ((ArrayTypeSignature)inputComponent).component;
        }
        if (inputComponent instanceof BaseType || inputComponent instanceof TypeVariableSignature) {
            return null;
        }
        ClassTypeSignature outputComponent = this.transform((ClassTypeSignature)inputComponent);
        if (outputComponent == null) {
            return null;
        }
        ArrayTypeSignature outputType = new ArrayTypeSignature(outputComponent);
        while (--componentDepth > 0) {
            outputType = new ArrayTypeSignature(outputType);
        }
        return outputType;
    }

    @Override
    public TypeParameter transform(TypeParameter inputTypeParameter) {
        ReferenceTypeSignature inputClassBound = inputTypeParameter.classBound;
        ReferenceTypeSignature outputClassBound = this.transform(inputClassBound);
        ReferenceTypeSignature[] inputBounds = inputTypeParameter.interfaceBounds;
        ReferenceTypeSignature[] outputBounds = null;
        for (int boundNo = 0; boundNo < inputBounds.length; ++boundNo) {
            ReferenceTypeSignature inputBound = inputBounds[boundNo];
            ReferenceTypeSignature outputBound = this.transform(inputBound);
            if (outputBound == null) continue;
            if (outputBounds == null) {
                outputBounds = (ReferenceTypeSignature[])inputBounds.clone();
            }
            outputBounds[boundNo] = outputBound;
        }
        if (outputClassBound == null && outputBounds == null) {
            return null;
        }
        return new TypeParameter(inputTypeParameter.identifier, outputClassBound == null ? inputClassBound : outputClassBound, outputBounds == null ? inputBounds : outputBounds);
    }

    @Override
    public ClassTypeSignature transform(ClassTypeSignature inputType) {
        String inputBinaryPackage;
        String outputBinaryPackage;
        String inputPackageSpecifier = inputType.packageSpecifier;
        String outputPackageSpecifier = null;
        int length = inputPackageSpecifier.length();
        if (length > 0 && (outputBinaryPackage = this.replaceBinaryPackage(inputBinaryPackage = inputPackageSpecifier.substring(0, length - 1))) != null) {
            outputPackageSpecifier = outputBinaryPackage + '/';
        }
        SimpleClassTypeSignature inputClassType = inputType.classType;
        SimpleClassTypeSignature outputClassType = this.transform(inputClassType);
        SimpleClassTypeSignature[] inputInnerTypes = inputType.innerTypes;
        SimpleClassTypeSignature[] outputInnerTypes = null;
        for (int typeNo = 0; typeNo < inputInnerTypes.length; ++typeNo) {
            SimpleClassTypeSignature inputInnerType = inputInnerTypes[typeNo];
            SimpleClassTypeSignature outputInnerType = this.transform(inputInnerType);
            if (outputInnerType == null) continue;
            if (outputInnerTypes == null) {
                outputInnerTypes = (SimpleClassTypeSignature[])inputInnerTypes.clone();
            }
            outputInnerTypes[typeNo] = outputInnerType;
        }
        if (outputPackageSpecifier == null && outputClassType == null && outputInnerTypes == null) {
            return null;
        }
        return new ClassTypeSignature(inputType.binary, outputPackageSpecifier == null ? inputPackageSpecifier : outputPackageSpecifier, outputClassType == null ? inputClassType : outputClassType, outputInnerTypes == null ? inputInnerTypes : outputInnerTypes);
    }

    @Override
    public SimpleClassTypeSignature transform(SimpleClassTypeSignature inputSignature) {
        TypeArgument[] inputArgs = inputSignature.typeArguments;
        TypeArgument[] outputArgs = null;
        for (int argNo = 0; argNo < inputArgs.length; ++argNo) {
            TypeArgument inputArg = inputArgs[argNo];
            TypeArgument outputArg = this.transform(inputArg);
            if (outputArg == null) continue;
            if (outputArgs == null) {
                outputArgs = (TypeArgument[])inputArgs.clone();
            }
            outputArgs[argNo] = outputArg;
        }
        if (outputArgs == null) {
            return null;
        }
        return new SimpleClassTypeSignature(inputSignature.identifier, outputArgs);
    }

    @Override
    public TypeArgument transform(TypeArgument inputArgument) {
        ReferenceTypeSignature inputSignature = inputArgument.type;
        ReferenceTypeSignature outputSignature = this.transform(inputSignature);
        if (outputSignature == null) {
            return null;
        }
        return new TypeArgument(inputArgument.wildcard, outputSignature);
    }

    @Override
    public JavaTypeSignature transform(JavaTypeSignature type) {
        if (type instanceof ReferenceTypeSignature) {
            return this.transform((ReferenceTypeSignature)type);
        }
        return null;
    }

    @Override
    public ReferenceTypeSignature transform(ReferenceTypeSignature type) {
        if (type instanceof ClassTypeSignature) {
            return this.transform((ClassTypeSignature)type);
        }
        if (type instanceof ArrayTypeSignature) {
            return this.transform((ArrayTypeSignature)type);
        }
        return null;
    }
}

