/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.CacheableString;
import fish.payara.microprofile.jwtauth.eesecurity.JwtKeyStoreUtils;
import fish.payara.microprofile.jwtauth.eesecurity.KeyLoadingCache;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.DeploymentException;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class JwtPrivateKeyStore {
    private final Config config = ConfigProvider.getConfig();
    private final Supplier<Optional<String>> cacheSupplier;
    private final Duration defaultCacheTTL;
    private String keyLocation = "/privateKey.pem";

    public JwtPrivateKeyStore(Duration defaultCacheTTL) {
        this.defaultCacheTTL = defaultCacheTTL;
        this.cacheSupplier = new KeyLoadingCache(this::readRawPrivateKey)::get;
    }

    public JwtPrivateKeyStore(Duration defaultCacheTTL, Optional<String> keyLocation) {
        this(defaultCacheTTL);
        this.keyLocation = keyLocation.orElse(this.keyLocation);
    }

    private CacheableString readRawPrivateKey() {
        CacheableString privateKey = JwtKeyStoreUtils.readKeyFromLocation(this.keyLocation, this.defaultCacheTTL);
        if (!privateKey.isPresent()) {
            privateKey = JwtKeyStoreUtils.readMPKeyFromLocation(this.config, "mp.jwt.decrypt.key.location", this.defaultCacheTTL);
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(String keyId) {
        return this.cacheSupplier.get().map(key -> this.createPrivateKey((String)key, keyId)).orElseThrow(() -> new IllegalStateException("No PrivateKey found"));
    }

    private PrivateKey createPrivateKey(String key, String keyId) {
        try {
            return this.createPrivateKeyFromPem(key);
        }
        catch (Exception pemEx) {
            try {
                return this.createPrivateKeyFromJWKS(key, keyId);
            }
            catch (Exception jwksEx) {
                throw new DeploymentException((Throwable)jwksEx);
            }
        }
    }

    private PrivateKey createPrivateKeyFromPem(String key) throws Exception {
        key = JwtKeyStoreUtils.trimPem(key);
        byte[] keyBytes = Base64.getDecoder().decode(key);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        return KeyFactory.getInstance("RSA").generatePrivate(privateKeySpec);
    }

    private PrivateKey createPrivateKeyFromJWKS(String jwksValue, String keyId) throws Exception {
        JsonObject jwks = JwtKeyStoreUtils.parseJwks(jwksValue);
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? JwtKeyStoreUtils.findJwk(keys, keyId) : jwks;
        String kty = jwk.getString("kty");
        if (kty == null) {
            throw new DeploymentException("Could not determine key type - kty field not present");
        }
        if (kty.equals("RSA")) {
            byte[] modulusBytes = Base64.getUrlDecoder().decode(jwk.getString("n"));
            BigInteger modulus = new BigInteger(1, modulusBytes);
            byte[] exponentBytes = Base64.getUrlDecoder().decode(jwk.getString("d"));
            BigInteger exponent = new BigInteger(1, exponentBytes);
            RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(modulus, exponent);
            return KeyFactory.getInstance("RSA").generatePrivate(privateKeySpec);
        }
        throw new DeploymentException("Could not determine key type - JWKS kty field does not equal RSA or EC");
    }
}

