/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.glassfish.bootstrap.osgi.Jar;
import com.sun.enterprise.glassfish.bootstrap.osgi.MinimalBundleProvisioner;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundleProvisioner {
    private static Logger logger = LogFacade.BOOTSTRAP_LOGGER;
    private BundleContext bundleContext;
    private boolean systemBundleUpdationRequired;
    private Map<URI, Jar> currentManagedBundles = new HashMap<URI, Jar>();
    private int noOfUninstalledBundles;
    private int noOfUpdatedBundles;
    private int noOfInstalledBundles;
    private Customizer customizer;
    private StartLevel sl;
    private PackageAdmin pa;

    public BundleProvisioner(BundleContext bundleContext, Properties config) {
        this(bundleContext, new DefaultCustomizer(config));
    }

    public BundleProvisioner(BundleContext bundleContext, Customizer customizer) {
        this.bundleContext = bundleContext;
        this.customizer = customizer;
        ServiceReference reference = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        this.sl = (StartLevel)StartLevel.class.cast(this.getBundleContext().getService(reference));
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<Long> installBundles() {
        this.initCurrentManagedBundles();
        Collection<Jar> current = this.getBundleJars();
        List<Jar> discovered = this.discoverJars();
        ArrayList<Jar> newBundles = new ArrayList<Jar>(discovered);
        newBundles.removeAll(current);
        ArrayList<Jar> deletedBundles = new ArrayList<Jar>(current);
        deletedBundles.removeAll(discovered);
        ArrayList<Jar> existingBundles = new ArrayList<Jar>(discovered);
        existingBundles.retainAll(current);
        this.uninstall(deletedBundles);
        this.update(existingBundles);
        this.install(newBundles);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Jar j : this.currentManagedBundles.values()) {
            ids.add(j.getBundleId());
        }
        return ids;
    }

    public void startBundles() {
        for (URI uri : this.getAutoStartLocations()) {
            Bundle bundle = this.getBundle(new Jar(uri));
            if (bundle == null) {
                logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00005", new Object[]{uri});
                continue;
            }
            this.startBundle(bundle);
        }
    }

    private void startBundle(Bundle bundle) {
        if (!this.isFragment(bundle)) {
            try {
                bundle.start(this.customizer.getStartOptions());
                logger.logp(Level.FINE, "BundleProvisioner", "startBundle", "Started bundle = {0}", new Object[]{bundle});
            }
            catch (BundleException e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00006", e, bundle);
            }
        }
    }

    private void initCurrentManagedBundles() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.getBundleContext().getBundles()) {
            try {
                Jar jar;
                long id = bundle.getBundleId();
                if (id == 0L || !this.customizer.isManaged(jar = new Jar(bundle))) continue;
                this.addBundle(jar);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private List<URI> getAutoInstallLocations() {
        return this.customizer.getAutoInstallLocations();
    }

    private List<URI> getAutoStartLocations() {
        return this.customizer.getAutoStartLocations();
    }

    private Integer getStartLevel(Jar jar) {
        return this.customizer.getStartLevel(jar);
    }

    private List<Jar> discoverJars() {
        ArrayList<Jar> jars = new ArrayList<Jar>();
        for (URI uri : this.getAutoInstallLocations()) {
            jars.add(new Jar(uri));
        }
        return jars;
    }

    protected int uninstall(List<Jar> bundles) {
        for (Jar jar : bundles) {
            Bundle bundle = this.getBundle(jar);
            if (bundle == null) {
                logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00007", new Object[]{jar.getPath()});
                continue;
            }
            try {
                if (this.isFrameworkExtensionBundle(bundle)) {
                    this.setSystemBundleUpdationRequired(true);
                }
                bundle.uninstall();
                ++this.noOfUninstalledBundles;
                this.removeBundle(jar);
                logger.log(Level.INFO, "NCLS-BOOTSTRAP-00008", new Object[]{bundle.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00011", e, jar.getPath());
            }
        }
        return this.noOfUninstalledBundles;
    }

    private int update(Collection<Jar> jars) {
        for (Jar jar : jars) {
            Jar existingJar;
            if (!jar.isNewer(existingJar = this.getBundleJar(jar))) continue;
            Bundle bundle = this.getBundle(existingJar);
            if (bundle == null) {
                logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00009", new Object[]{existingJar.getPath()});
                continue;
            }
            try {
                if (this.isFrameworkExtensionBundle(bundle)) {
                    this.setSystemBundleUpdationRequired(true);
                }
                bundle.update();
                ++this.noOfUpdatedBundles;
                logger.log(Level.INFO, "NCLS-BOOTSTRAP-00010", new Object[]{bundle.getBundleId(), jar.getPath()});
            }
            catch (Exception e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00012", e, jar.getPath());
            }
        }
        return this.noOfUpdatedBundles;
    }

    private Collection<Jar> getBundleJars() {
        return this.currentManagedBundles.values();
    }

    private Jar getBundleJar(Jar jar) {
        return this.currentManagedBundles.get(jar.getURI());
    }

    private void addBundle(Jar jar) throws URISyntaxException {
        this.currentManagedBundles.put(jar.getURI(), jar);
    }

    private void removeBundle(Jar jar) throws URISyntaxException {
        this.currentManagedBundles.remove(jar.getURI());
    }

    private Bundle getBundle(Jar jar) {
        Jar jar1;
        long bundleId = jar.getBundleId();
        if (bundleId < 0L && (jar1 = this.currentManagedBundles.get(jar.getURI())) != null) {
            bundleId = jar1.getBundleId();
        }
        return this.getBundleContext().getBundle(bundleId);
    }

    private boolean isFrameworkExtensionBundle(Bundle bundle) {
        if (this.isFragment(bundle)) {
            String fragmentHost = (String)bundle.getHeaders().get("Fragment-Host");
            String separator = ";";
            for (String s : fragmentHost.split(";")) {
                String directiveName;
                int idx = s.indexOf(":=");
                if (idx == -1 || !(directiveName = s.substring(0, idx).trim()).equals("extension") || !s.substring(idx + 2).trim().equals("framework")) continue;
                logger.logp(Level.FINE, "BundleProvisioner", "isSystemBundleFragment", "{0} is a framework extension bundle", new Object[]{bundle});
                return true;
            }
        }
        return false;
    }

    private boolean isFragment(Bundle bundle) {
        ServiceReference reference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)PackageAdmin.class.cast(this.getBundleContext().getService(reference));
        return pa.getBundleType(bundle) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int install(Collection<Jar> jars) {
        for (Jar jar : jars) {
            try {
                InputStream is = jar.getURI().toURL().openStream();
                try {
                    Bundle b = this.getBundleContext().installBundle(this.makeLocation(jar), is);
                    Integer startLevel = this.getStartLevel(jar);
                    if (startLevel != null) {
                        this.getStartLevelService().setBundleStartLevel(b, startLevel.intValue());
                    }
                    ++this.noOfInstalledBundles;
                    this.addBundle(new Jar(b));
                    logger.logp(Level.FINE, "BundleProvisioner", "install", "Installed bundle {0} from {1} ", new Object[]{b.getBundleId(), jar.getURI()});
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00013", e, jar.getURI());
            }
        }
        return this.noOfInstalledBundles;
    }

    private StartLevel getStartLevelService() {
        return this.sl;
    }

    private String makeLocation(Jar jar) {
        return this.customizer.makeLocation(jar);
    }

    public void refresh() {
        ServiceReference reference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)PackageAdmin.class.cast(this.getBundleContext().getService(reference));
        pa.refreshPackages(null);
        this.getBundleContext().ungetService(reference);
    }

    public boolean hasAnyThingChanged() {
        return this.getNoOfInstalledBundles() + this.getNoOfUninstalledBundles() + this.getNoOfUpdatedBundles() > 0;
    }

    public boolean isSystemBundleUpdationRequired() {
        return this.systemBundleUpdationRequired;
    }

    protected void setSystemBundleUpdationRequired(boolean systemBundleUpdationRequired) {
        this.systemBundleUpdationRequired = systemBundleUpdationRequired;
    }

    public int getNoOfUninstalledBundles() {
        return this.noOfUninstalledBundles;
    }

    public int getNoOfUpdatedBundles() {
        return this.noOfUpdatedBundles;
    }

    public int getNoOfInstalledBundles() {
        return this.noOfInstalledBundles;
    }

    public Customizer getCustomizer() {
        return this.customizer;
    }

    public static void main(String[] args) throws Exception {
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00017");
        Properties props = new Properties();
        props.load(new FileInputStream(args[0]));
        Util.substVars(props);
        long t0 = System.currentTimeMillis();
        Framework framework = null;
        HashMap mm = new HashMap();
        props.putAll((Map<?, ?>)mm);
        Iterator<FrameworkFactory> iterator = ServiceLoader.load(FrameworkFactory.class).iterator();
        if (iterator.hasNext()) {
            FrameworkFactory frameworkFactory = iterator.next();
            framework = frameworkFactory.newFramework(mm);
            System.out.println("framework = " + framework);
        }
        if (framework == null) {
            throw new RuntimeException("no OSGi framework in classpath");
        }
        long t1 = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00018", t1 - t0);
        framework.init();
        long t2 = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00020", t2 - t1);
        BundleProvisioner bundleProvisioner = BundleProvisioner.createBundleProvisioner(framework.getBundleContext(), props);
        bundleProvisioner.installBundles();
        long t3 = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00021", t3 - t2);
        int installed = bundleProvisioner.getNoOfInstalledBundles();
        int updated = bundleProvisioner.getNoOfUpdatedBundles();
        int uninstalled = bundleProvisioner.getNoOfUninstalledBundles();
        System.out.printf("installed = %d, updated = %d, uninstalled = %d\n", installed, updated, uninstalled);
        if (bundleProvisioner.hasAnyThingChanged()) {
            System.out.println("Refreshing framework");
            bundleProvisioner.refresh();
        }
        bundleProvisioner.startBundles();
        framework.start();
        long t4 = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00022", t4 - t3);
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00023", t4 - t0);
        if (args.length == 3 && args[2].equalsIgnoreCase("wait-before-stopping")) {
            System.out.println("Hit enter to continue");
            System.in.read();
        }
        framework.stop();
        framework.waitForStop(0L);
        long t5 = System.currentTimeMillis();
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00024", t5 - t4);
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00025", t5 - t0);
        try (PrintStream out = new PrintStream(new FileOutputStream(args[1], true));){
            out.printf("%d,%d,%d,%d,%d,%d,%d\n", t1 - t0, t2 - t1, t3 - t2, t4 - t3, t4 - t0, t5 - t4, t5 - t0);
        }
    }

    static BundleProvisioner createBundleProvisioner(BundleContext bctx, Properties props) {
        Class clazz = Boolean.valueOf(props.getProperty("glassfish.osgi.ondemand")) != false ? MinimalBundleProvisioner.class : BundleProvisioner.class;
        logger.log(Level.INFO, "NCLS-BOOTSTRAP-00026", clazz);
        try {
            Constructor constructor = clazz.getConstructor(BundleContext.class, Properties.class);
            return (BundleProvisioner)constructor.newInstance(bctx, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class DefaultCustomizer
    implements Customizer {
        private Properties config;
        private final Map<URI, Integer> startLevels = new HashMap<URI, Integer>();
        private List<URI> autoInstallLocations;
        private List<URI> autoStartLocations;
        private List<URI> configuredAutoInstallLocations;

        public DefaultCustomizer(Properties config) {
            this.config = config;
            this.processAutoInstallLocations();
            this.processAutoStartLocations();
            this.processStartLevels();
        }

        private void processAutoInstallLocations() {
            String list = this.config.getProperty("glassfish.osgi.auto.install");
            this.configuredAutoInstallLocations = this.getLocations(list, false);
            this.autoInstallLocations = this.getLocations(list);
        }

        private void processAutoStartLocations() {
            String list = this.config.getProperty("glassfish.osgi.auto.start");
            this.autoStartLocations = this.getLocations(list);
        }

        private void processStartLevels() {
            for (String key : this.config.stringPropertyNames()) {
                if (!key.startsWith("glassfish.osgi.auto.start.level")) continue;
                try {
                    Integer startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                    String list = this.config.getProperty(key);
                    for (URI uri : this.getLocations(list)) {
                        if (this.startLevels.containsKey(uri)) {
                            logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00014", new Object[]{uri, this.startLevels.get(uri), startLevel});
                            continue;
                        }
                        this.startLevels.put(uri, startLevel);
                    }
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
        }

        @Override
        public List<URI> getAutoInstallLocations() {
            return this.autoInstallLocations;
        }

        @Override
        public List<URI> getAutoStartLocations() {
            return this.autoStartLocations;
        }

        private List<URI> getLocations(String list) {
            return this.getLocations(list, true);
        }

        private List<URI> getLocations(String list, boolean expand) {
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<URI> uris = new ArrayList<URI>();
            for (String s : list.split("\\s")) {
                try {
                    URI uri = new URI(s);
                    if (!uri.isAbsolute()) {
                        logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00015", new Object[]{uri});
                        continue;
                    }
                    if (expand && this.isDirectory(uri)) {
                        uris.addAll(this.listJarFiles(uri));
                        continue;
                    }
                    uris.add(uri);
                }
                catch (URISyntaxException e) {
                    LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00016", e, s);
                }
            }
            return uris;
        }

        @Override
        public int getStartOptions() {
            String s = this.config.getProperty("glassfish.osgi.auto.start.options");
            if (s != null) {
                return Integer.parseInt(s);
            }
            return 2;
        }

        @Override
        public String makeLocation(Jar jar) {
            return jar.getURI().toString();
        }

        protected boolean isDirectory(URI uri) {
            try {
                return new File(uri).isDirectory();
            }
            catch (Exception e) {
                return false;
            }
        }

        protected List<? extends URI> listJarFiles(URI aDirectoryURI) {
            assert ("file".equalsIgnoreCase(aDirectoryURI.getScheme()));
            final ArrayList jarURIs = new ArrayList();
            new File(aDirectoryURI).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.getName().endsWith(".jar") && !pathname.isDirectory()) {
                        jarURIs.add(pathname.toURI());
                        return true;
                    }
                    return false;
                }
            });
            return jarURIs;
        }

        @Override
        public boolean isManaged(Jar jar) {
            URI uri = jar.getURI();
            if (uri == null) {
                return false;
            }
            for (URI configuredLocation : this.getConfiguredAutoInstallLocations()) {
                String otherLocationAsString = configuredLocation.toString();
                if (!uri.toString().regionMatches(0, otherLocationAsString, 0, otherLocationAsString.length())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Integer getStartLevel(Jar jar) {
            return this.startLevels.get(jar.getURI());
        }

        protected List<URI> getConfiguredAutoInstallLocations() {
            return this.configuredAutoInstallLocations;
        }
    }

    static interface Customizer {
        public String makeLocation(Jar var1);

        public boolean isManaged(Jar var1);

        public List<URI> getAutoInstallLocations();

        public List<URI> getAutoStartLocations();

        public int getStartOptions();

        public Integer getStartLevel(Jar var1);
    }
}

