/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import fish.payara.appserver.monitoring.rest.service.adapter.RestMonitoringEndpointDecider;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.Events;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
public final class RestMonitoringAdapter
extends HttpHandler
implements Adapter {
    private boolean isRegistered = false;
    private boolean appRegistered = false;
    private ResourceBundle bundle;
    private final Method[] allowedHttpMethods = new Method[]{Method.GET, Method.POST, Method.HEAD, Method.DELETE, Method.PUT};
    private static RestMonitoringEndpointDecider endpointDecider;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    @Inject
    Events events;
    @Inject
    @Named(value="default-instance-name")
    Config serverConfig;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    RestMonitoringConfiguration restMonitoringServiceConfiguration;
    private static final Logger logger;
    private static final String RESOURCE_PACKAGE = "fish/payara/appserver/monitoring/rest/service/adapter";
    private final CountDownLatch latch = new CountDownLatch(1);

    @PostConstruct
    public void postConstruct() {
        this.restMonitoringServiceConfiguration = (RestMonitoringConfiguration)this.habitat.getService(RestMonitoringConfiguration.class, new Annotation[0]);
        this.init();
    }

    private void init() {
        try {
            endpointDecider = new RestMonitoringEndpointDecider(this.serverConfig, this.restMonitoringServiceConfiguration);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Rest Monitoring Console cannot initialise", ex);
        }
        if (this.appExistsInConfig() && this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), this.restMonitoringServiceConfiguration.getApplicationName()) != null) {
            this.setAppRegistered(true);
        }
    }

    public boolean appExistsInConfig() {
        return this.getSystemApplicationConfig() != null;
    }

    public boolean appExistsInConfig(String contextRoot) {
        return this.getSystemApplicationConfig(contextRoot) != null;
    }

    public Application getSystemApplicationConfig() {
        Application application = this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), this.restMonitoringServiceConfiguration.getApplicationName());
        if (application == null) {
            application = this.getApplicationWithMatchingContextRoot(this.getContextRoot());
        }
        return application;
    }

    public Application getSystemApplicationConfig(String contextRoot) {
        Application application = this.getApplicationWithMatchingContextRoot(contextRoot);
        return application;
    }

    private Application getApplicationWithMatchingContextRoot(String contextRoot) {
        Application application = null;
        SystemApplications systemApplications = this.domain.getSystemApplications();
        for (Application systemApplication : systemApplications.getApplications()) {
            if (!systemApplication.getContextRoot().equals(contextRoot)) continue;
            application = systemApplication;
            break;
        }
        return application;
    }

    public void service(Request request, Response response) throws Exception {
        this.bundle = this.getResourceBundle(request.getLocale());
        Method method = request.getMethod();
        if (!this.checkHttpMethodAllowed(method)) {
            response.setStatus(405, method.getMethodString() + " " + this.bundle.getString("http.bad.method"));
            response.setHeader("Allow", this.getAllowedHttpMethodsAsString());
            return;
        }
        try {
            if (!this.latch.await(100L, TimeUnit.SECONDS)) {
                logger.log(Level.SEVERE, "Timed out processing a rest monitoring request");
                return;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Cannot process rest monitoring request");
            return;
        }
        if (this.isResourceRequest(request)) {
            block8: {
                try {
                    this.handleResourceRequest(request, response);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "Unable to serve resource: {0}. Cause: {1}", new Object[]{request.getRequestURI(), ioe.toString()});
                    }
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(RestMonitoringAdapter.class.getPackage().getName() + ".LocalStrings", locale);
    }

    private boolean checkHttpMethodAllowed(Method method) {
        for (Method allowedMethod : this.allowedHttpMethods) {
            if (!allowedMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    private String getAllowedHttpMethodsAsString() {
        StringBuilder sb = new StringBuilder(this.allowedHttpMethods[0].getMethodString());
        for (int i = 1; i < this.allowedHttpMethods.length; ++i) {
            sb.append(", ").append(this.allowedHttpMethods[i].getMethodString());
        }
        return sb.toString();
    }

    private boolean isResourceRequest(Request request) {
        return this.getContentType(request.getRequestURI()) != null;
    }

    private String getContentType(String resource) {
        if (resource == null || resource.length() == 0) {
            return null;
        }
        if (resource.endsWith(".gif")) {
            return "image/gif";
        }
        if (resource.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unhandled content-type: {0}", resource);
        }
        return null;
    }

    private void handleResourceRequest(Request request, Response response) throws IOException {
        String resourcePath = RESOURCE_PACKAGE + request.getRequestURI();
        ClassLoader loader = RestMonitoringAdapter.class.getClassLoader();
        try (InputStream inputStream = loader.getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                logger.log(Level.WARNING, "Resource not found: {0}", resourcePath);
                return;
            }
            byte[] buffer = new byte[512];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            int i = inputStream.read(buffer);
            while (i != -1) {
                byteArrayOutputStream.write(buffer, 0, i);
                i = inputStream.read(buffer);
            }
            String contentType = this.getContentType(resourcePath);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            response.setContentLength(byteArrayOutputStream.size());
            OutputStream outputStream = response.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
        }
    }

    @Override
    public HttpHandler getHttpService() {
        return this;
    }

    @Override
    public String getContextRoot() {
        return endpointDecider == null ? null : endpointDecider.getContextRoot();
    }

    @Override
    public int getListenPort() {
        return endpointDecider == null ? -1 : endpointDecider.getListenPort();
    }

    @Override
    public InetAddress getListenAddress() {
        return endpointDecider == null ? null : endpointDecider.getListenAddress();
    }

    @Override
    public List<String> getVirtualServers() {
        return endpointDecider == null ? Collections.emptyList() : endpointDecider.getHosts();
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public boolean isAppRegistered() {
        return this.appRegistered;
    }

    public void setAppRegistered(boolean appRegistered) {
        this.appRegistered = true;
    }

    public boolean isAppRegistered(String contextRoot) {
        boolean registered = false;
        Application application = this.getSystemApplicationConfig(contextRoot);
        if (application != null && this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), application.getName()) != null) {
            registered = true;
        }
        return registered;
    }

    static {
        logger = Logger.getLogger(RestMonitoringAdapter.class.getName());
    }
}

