/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.event;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.swt.widgets.Composite;

public class InlineCellEditEvent
implements ILayerEvent {
    private PositionCoordinate cellCoordinate;
    private final Composite parent;
    private final IConfigRegistry configRegistry;
    private final Object initialValue;

    public InlineCellEditEvent(PositionCoordinate cellCoordinate, Composite parent, IConfigRegistry configRegistry, Object initialValue) {
        this.cellCoordinate = cellCoordinate;
        this.parent = parent;
        this.configRegistry = configRegistry;
        this.initialValue = initialValue;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        int convertedColumn = localLayer.underlyingToLocalColumnPosition(this.cellCoordinate.getLayer(), this.cellCoordinate.columnPosition);
        int convertedRow = localLayer.underlyingToLocalRowPosition(this.cellCoordinate.getLayer(), this.cellCoordinate.rowPosition);
        if (convertedColumn < 0 || convertedColumn >= localLayer.getColumnCount() || convertedRow < 0 || convertedRow >= localLayer.getRowCount()) {
            return false;
        }
        this.cellCoordinate = new PositionCoordinate(localLayer, convertedColumn, convertedRow);
        return true;
    }

    public int getColumnPosition() {
        return this.cellCoordinate.columnPosition;
    }

    public int getRowPosition() {
        return this.cellCoordinate.rowPosition;
    }

    public Composite getParent() {
        return this.parent;
    }

    public IConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    @Override
    public InlineCellEditEvent cloneEvent() {
        return new InlineCellEditEvent(new PositionCoordinate(this.cellCoordinate), this.parent, this.configRegistry, this.initialValue);
    }
}

