/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.MoveAndReconnectCommand;
import org.eclipse.fordiac.ide.application.utilities.SubAppHierarchyDialog;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveThroughHierarchyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        List fbelements;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && !(fbelements = HandlerHelper.getSelectedFBNElements((ISelection)(selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)))).isEmpty() && MoveThroughHierarchyHandler.allElementsFromSameNetwork(fbelements)) {
            SubApp subapp;
            SubAppHierarchyDialog dialog = new SubAppHierarchyDialog((FBNetworkElement)fbelements.get(0), fbelements);
            FBNetwork destinationNetwork = dialog.open();
            if (destinationNetwork == null) {
                return Status.CANCEL_STATUS;
            }
            Point destination = MoveThroughHierarchyHandler.getDestination(editor, fbelements, destinationNetwork);
            MoveAndReconnectCommand cmd = new MoveAndReconnectCommand(fbelements, destination, destinationNetwork);
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)cmd);
            EObject obj = destinationNetwork.eContainer();
            while (obj instanceof SubApp && (subapp = (SubApp)obj).isUnfolded()) {
                obj = subapp.eContainer().eContainer();
            }
            GraphicalViewer viewer = (GraphicalViewer)HandlerHelper.openEditor((EObject)obj).getAdapter(GraphicalViewer.class);
            HandlerHelper.selectElement(fbelements.get(0), (GraphicalViewer)viewer);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        List fbElements = HandlerHelper.getSelectedFBNElements((ISelection)selection);
        if (!fbElements.isEmpty()) {
            FBNetwork parent = ((FBNetworkElement)fbElements.get(0)).getFbNetwork();
            boolean sameParentNetwork = fbElements.stream().allMatch(el -> parent.equals(el.getFbNetwork()));
            this.setBaseEnabled(sameParentNetwork);
            return;
        }
        this.setBaseEnabled(false);
    }

    private static boolean allElementsFromSameNetwork(List<FBNetworkElement> fbelements) {
        FBNetwork source = fbelements.get(0).getFbNetwork();
        return fbelements.stream().allMatch(el -> source.equals(el.getFbNetwork()));
    }

    private static GraphicalViewer getViewer(FBNetwork subappNetwork, IEditorPart parent) {
        if (!HandlerHelper.getFBNetwork((IEditorPart)parent).equals(subappNetwork)) {
            return HandlerHelper.getViewer((IEditorPart)HandlerHelper.openEditor((EObject)subappNetwork.eContainer()));
        }
        return HandlerHelper.getViewer((IEditorPart)parent);
    }

    private static Point getDestination(IEditorPart editor, List<FBNetworkElement> fbelements, FBNetwork destinationNetwork) {
        GraphicalViewer viewer = MoveThroughHierarchyHandler.getViewer(destinationNetwork, editor);
        viewer.flush();
        EObject obj = fbelements.get(0).getFbNetwork().eContainer();
        while (obj.eContainer() != null && obj.eContainer() != destinationNetwork) {
            obj = obj.eContainer();
        }
        GraphicalEditPart ep = (GraphicalEditPart)viewer.getEditPartForModel((Object)obj);
        Rectangle bounds = ep != null ? ep.getFigure().getBounds().getCopy() : new Rectangle();
        int destX = bounds.x;
        int destY = bounds.y + bounds.height + 20;
        return new Point(destX, destY);
    }
}

