/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ProviderDocumentUndoChange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ProviderDocumentChange
extends TextChange {
    private final IFileEditorInput editorInput;
    private final IDocumentProvider documentProvider;
    private final boolean doSave;
    private long modificationStamp = -1L;

    public ProviderDocumentChange(String name, IFileEditorInput editorInput, IDocumentProvider documentProvider) {
        this(name, editorInput, documentProvider, true);
    }

    public ProviderDocumentChange(String name, IFileEditorInput editorInput, IDocumentProvider documentProvider, boolean doSave) {
        super(name);
        this.editorInput = editorInput;
        this.documentProvider = documentProvider;
        this.doSave = doSave;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        this.documentProvider.connect((Object)this.editorInput);
        IDocument document = this.documentProvider.getDocument((Object)this.editorInput);
        if (document == null) {
            this.documentProvider.disconnect((Object)this.editorInput);
        }
        return document;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.doSave) {
            this.documentProvider.saveDocument(pm, (Object)this.editorInput, document, false);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        this.documentProvider.disconnect((Object)this.editorInput);
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new ProviderDocumentUndoChange(this.getName(), this.editorInput, this.documentProvider, edit, this.doSave);
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.modificationStamp = this.documentProvider.getModificationStamp((Object)this.editorInput);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.modificationStamp != this.documentProvider.getModificationStamp((Object)this.editorInput)) {
            refactoringStatus.addFatalError("The content of the document has changed.");
        }
        return refactoringStatus;
    }

    public Object getModifiedElement() {
        return null;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.editorInput.getFile()};
    }
}

