/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyFactory;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyPackage;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.util.HierarchyResourceFactoryImpl;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.util.HierarchyResourceImpl;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PlantHierarchyView
extends CommonNavigator
implements ITabbedPropertySheetPageContributor {
    private static final String PLANT_HIERARCHY_PROJECT = "PlantHierarchy.Project";
    public static final String PLANT_HIERARCHY_FILE_NAME_EXTENSION = "HIER";
    public static final String PLANT_HIERARCHY_FILE_NAME_EXTENSION_WITH_DOT = ".HIER";
    private static final String PLANT_HIERARCHY_FILE_NAME = ".plant" + ".HIER".toLowerCase();
    public static final String PROPERTY_CONTRIBUTOR_ID = "org.eclipse.fordiac.ide.hierarchymanager.ui.view";
    final Map<String, Object> loadOptions = new HashMap<String, Object>();
    private final ResourceSet hierarchyResouceSet = new ResourceSetImpl();
    private IProject currentProject;

    public PlantHierarchyView() {
        this.setupEMFInfra();
    }

    protected void setPartName(String partName) {
        if (this.currentProject != null) {
            super.setPartName(partName + ": " + this.currentProject.getName());
        } else {
            super.setPartName(partName);
        }
    }

    public boolean show(ShowInContext context) {
        if (context == null) {
            return false;
        }
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IProject selProject;
            IStructuredSelection structSel = (IStructuredSelection)selection;
            if (!selection.isEmpty() && (selProject = PlantHierarchyView.getSelectedProject(structSel.getFirstElement())) != null) {
                this.setInput(selProject);
                return true;
            }
        }
        return super.show(context);
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        if (this.currentProject != null) {
            aMemento.putString(PLANT_HIERARCHY_PROJECT, this.currentProject.getName());
        }
    }

    protected Object getInitialInput() {
        IProject project;
        String projectName;
        if (this.memento != null && (projectName = this.memento.getString(PLANT_HIERARCHY_PROJECT)) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists() && project.isOpen()) {
            this.currentProject = project;
            return PlantHierarchyView.loadHierachyForProject(this.currentProject, this.hierarchyResouceSet, this.loadOptions);
        }
        return super.getInitialInput();
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        Tree treeWidget = this.getCommonViewer().getTree();
        treeWidget.addListener(3, event -> {
            TreeItem item = treeWidget.getItem(new Point(event.x, event.y));
            if (item == null) {
                this.getCommonViewer().setSelection((ISelection)TreeSelection.EMPTY);
            }
        });
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public void setInput(IProject proj) {
        if (this.currentProject != proj) {
            this.currentProject = proj;
            this.getCommonViewer().setInput((Object)PlantHierarchyView.loadHierachyForProject(proj, this.hierarchyResouceSet, this.loadOptions));
            this.setPartName(this.getConfigurationElement().getAttribute("name"));
        }
    }

    private static IProject getSelectedProject(Object firstElement) {
        IProject proj;
        if (firstElement instanceof EObject) {
            EObject eObj = (EObject)firstElement;
            return PlantHierarchyView.getProjectFromEObject(eObj);
        }
        if (firstElement instanceof IResource) {
            IResource res = (IResource)firstElement;
            return res.getProject();
        }
        return firstElement instanceof IProject ? (proj = (IProject)firstElement) : null;
    }

    private static IProject getProjectFromEObject(EObject eObj) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObj);
        if (rootContainer instanceof LibraryElement) {
            LibraryElement le = (LibraryElement)rootContainer;
            return le.getTypeEntry().getFile().getProject();
        }
        return null;
    }

    public static EObject loadHierachyForProject(IProject proj, ResourceSet hierarchyResouceSet, Map<String, Object> loadOptions) {
        IFile file = proj.getFile(PLANT_HIERARCHY_FILE_NAME);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        if (!file.exists()) {
            return PlantHierarchyView.createNewHierarchyFile(file, uri, hierarchyResouceSet);
        }
        Resource resource = hierarchyResouceSet.getResource(uri, true);
        try {
            if (resource == null) {
                resource = new HierarchyResourceImpl(uri);
                hierarchyResouceSet.getResources().add((Object)resource);
                resource.load(loadOptions);
            }
            return (EObject)resource.getContents().get(0);
        }
        catch (IOException e) {
            FordiacLogHelper.logWarning((String)"Could not load plant hierarchy", (Exception)e);
            return null;
        }
    }

    public static EObject createNewHierarchyFile(IFile file, URI uri, ResourceSet hierarchyResouceSet) {
        Resource resource = hierarchyResouceSet.getResource(uri, false);
        if (resource == null) {
            resource = new HierarchyResourceImpl(uri);
            hierarchyResouceSet.getResources().add((Object)resource);
        }
        RootLevel root = HierarchyFactory.eINSTANCE.createRootLevel();
        resource.getContents().add((Object)root);
        PlantHierarchyView.saveNewResource(file, resource);
        return root;
    }

    private static void saveNewResource(IFile file, final Resource resource) {
        WorkspaceJob job = new WorkspaceJob("Save plant hierarchy: " + resource.getURI().toFileString()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    resource.save(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(20);
        job.setRule((ISchedulingRule)file.getParent());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)"Could not wait for plant hierarchy creation", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void setupEMFInfra() {
        this.hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(PLANT_HIERARCHY_FILE_NAME_EXTENSION, new HierarchyResourceFactoryImpl());
        this.hierarchyResouceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(PLANT_HIERARCHY_FILE_NAME_EXTENSION.toLowerCase(), new HierarchyResourceFactoryImpl());
        this.setupLoadOptions();
    }

    private void setupLoadOptions() {
        this.loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
        XMLMapImpl map = new XMLMapImpl();
        map.setNoNamespacePackage((EPackage)HierarchyPackage.eINSTANCE);
        this.loadOptions.put("XML_MAP", map);
        this.hierarchyResouceSet.getLoadOptions().put("XML_MAP", map);
    }

    public String getContributorId() {
        return PROPERTY_CONTRIBUTOR_ID;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        return (T)super.getAdapter(adapter);
    }
}

