/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.eval.value.ECStateValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class ECStateVariable
extends AbstractVariable<ECStateValue> {
    public static final String NAME = "__STATE";
    private ECStateValue value;

    public ECStateVariable(BasicFBType type) {
        this(type.getECC().getStart());
    }

    public ECStateVariable(ECState state) {
        this(state.getECC().getBasicFBType(), new ECStateValue(state));
    }

    public ECStateVariable(BasicFBType type, String value) {
        super(NAME, (INamedElement)type);
        this.setValue(value);
    }

    public ECStateVariable(BasicFBType type, Value value) {
        super(NAME, (INamedElement)type);
        this.setValue(value);
    }

    @Override
    public void setValue(Value value) {
        ECStateValue stateValue;
        if (!(value instanceof ECStateValue) || (stateValue = (ECStateValue)value).getType() != this.getType()) {
            throw this.createCastException(value);
        }
        this.value = stateValue;
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) {
        this.value = new ECStateValue(this.getType().getECC().getECState().stream().filter(state -> state.getName().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("No state named " + value + " in type " + this.getType().getName())));
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        return this.getType().getECC().getECState().stream().anyMatch(state -> state.getName().equals(value));
    }

    public BasicFBType getType() {
        return (BasicFBType)super.getType();
    }

    @Override
    public ECStateValue getValue() {
        return this.value;
    }
}

