/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SubAppHierarchyDialog {
    private final FBNetwork root;
    private TreeNode rootNode;
    private final ElementTreeSelectionDialog dialog;

    public SubAppHierarchyDialog(FBNetworkElement root, List<FBNetworkElement> filteredElements) {
        this.root = (FBNetwork)root.eContainer();
        List<TreeNode> nodeList = this.buildNodeList(filteredElements);
        this.dialog = this.createDialog();
        this.dialog.setInput((Object)nodeList.toArray(new TreeNode[0]));
        this.dialog.setTitle(Messages.MoveElementDialogTitle);
        this.dialog.setAllowMultiple(false);
        this.dialog.setInitialSelection((Object)this.rootNode);
    }

    public FBNetwork open() {
        TreeNode node;
        Object result;
        this.dialog.open();
        Object object = result = this.dialog.getResult() != null ? this.dialog.getResult()[0] : null;
        if (result instanceof TreeNode && (node = (TreeNode)result) != this.rootNode) {
            Object object2 = node.getValue();
            Objects.requireNonNull(object2);
            Object object3 = object2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubApp.class, Application.class, CompositeFBType.class}, (Object)object3, n)) {
                case 0 -> {
                    SubApp subapp = (SubApp)object3;
                    yield subapp.getSubAppNetwork();
                }
                case 1 -> {
                    Application app = (Application)object3;
                    yield app.getFBNetwork();
                }
                case 2 -> {
                    CompositeFBType cfb = (CompositeFBType)object3;
                    yield cfb.getFBNetwork();
                }
                default -> null;
            };
        }
        return null;
    }

    private ElementTreeSelectionDialog createDialog() {
        return new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeNodeLabelProvider()), (ITreeContentProvider)new TreeNodeContentProvider()){

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer viewer = super.createTreeViewer(parent);
                viewer.expandAll();
                return viewer;
            }
        };
    }

    private List<TreeNode> buildNodeList(List<FBNetworkElement> filterList) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        EObject container = EcoreUtil.getRootContainer((EObject)this.root);
        if (container instanceof AutomationSystem) {
            AutomationSystem as = (AutomationSystem)container;
            as.getApplication().forEach(app -> {
                TreeNode node = new TreeNode(app);
                nodeList.add(node);
                if (app.getFBNetwork() == this.root) {
                    this.rootNode = node;
                }
                this.addFBNetwork(node, app.getFBNetwork(), filterList);
            });
        } else if (container instanceof CompositeFBType) {
            CompositeFBType cfb = (CompositeFBType)container;
            TreeNode node = new TreeNode((Object)cfb);
            nodeList.add(node);
            if (cfb.getFBNetwork() == this.root) {
                this.rootNode = node;
            }
            this.addFBNetwork(node, cfb.getFBNetwork(), filterList);
        }
        return nodeList;
    }

    private void addFBNetwork(TreeNode parent, FBNetwork network, List<FBNetworkElement> filterList) {
        ArrayList nodeList = new ArrayList();
        network.getNetworkElements().forEach(fbnE -> {
            if (fbnE instanceof UntypedSubApp) {
                UntypedSubApp subapp = (UntypedSubApp)fbnE;
                if (!filterList.contains(fbnE)) {
                    TreeNode node = new TreeNode((Object)subapp);
                    if (subapp.getSubAppNetwork() == this.root) {
                        this.rootNode = node;
                    }
                    node.setParent(parent);
                    nodeList.add(node);
                    this.addFBNetwork(node, subapp.getSubAppNetwork(), filterList);
                }
            }
        });
        parent.setChildren(nodeList.toArray(new TreeNode[0]));
    }

    private class TreeNodeLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private TreeNodeLabelProvider() {
        }

        public String getText(Object element) {
            TreeNode treeNode;
            Object object;
            if (element instanceof TreeNode && (object = (treeNode = (TreeNode)element).getValue()) instanceof INamedElement) {
                INamedElement e = (INamedElement)object;
                return e.getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (node.getValue() instanceof UntypedSubApp) {
                    return FordiacImage.ICON_SUB_APP.getImage();
                }
                if (node.getValue() instanceof TypedSubApp) {
                    return FordiacImage.ICON_SUB_APP.getImage();
                }
                if (node.getValue() instanceof SubAppType) {
                    return FordiacImage.ICON_SUB_APP_TYPE.getImage();
                }
                if (node.getValue() instanceof Application) {
                    return FordiacImage.ICON_APPLICATION.getImage();
                }
            }
            return super.getImage(element);
        }

        public StyledString getStyledText(Object element) {
            TreeNode treeNode;
            if (element instanceof TreeNode && (treeNode = (TreeNode)element) == SubAppHierarchyDialog.this.rootNode) {
                StyledString styledString = new StyledString(this.getText(element));
                styledString.append(" - current Network", StyledString.QUALIFIER_STYLER);
                return styledString;
            }
            return new StyledString(this.getText(element));
        }
    }
}

