/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.function;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class FunctionFBTemplate
extends ForteFBTemplate<FunctionFBType> {
    private final ILanguageSupport bodyLanguageSupport;

    protected FunctionFBTemplate(FunctionFBType type, String name, Path prefix, String baseClass, Map<?, ?> options) {
        super(type, name, prefix, baseClass, options);
        this.bodyLanguageSupport = type.getBody() != null ? ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)type.getBody(), options) : null;
    }

    protected CharSequence generateFunctionSignature() {
        StringBuilder builder = new StringBuilder();
        if (((FunctionFBType)this.getType()).getReturnType() != null) {
            builder.append(ForteNgExportUtil.generateTypeName((INamedElement)((FunctionFBType)this.getType()).getReturnType()));
        } else {
            builder.append("void");
        }
        builder.append(" func_");
        builder.append(((FunctionFBType)this.getType()).getName());
        builder.append('(');
        builder.append(this.generateFunctionParameters());
        builder.append(')');
        return builder;
    }

    protected CharSequence generateFunctionParameters() {
        return this.getFunctionParameters().map(FunctionFBTemplate::generateFunctionParameter).collect(Collectors.joining(", "));
    }

    protected static CharSequence generateFunctionParameter(VarDeclaration param) {
        boolean reference = param.isInOutVar() || !param.isIsInput();
        StringBuilder builder = new StringBuilder();
        builder.append(FunctionFBTemplate.generateParameterTypeName(param, reference));
        builder.append(' ');
        if (reference) {
            builder.append('&');
        }
        builder.append(ForteNgExportUtil.generateName((IInterfaceElement)param));
        return builder;
    }

    protected Stream<VarDeclaration> getFunctionParameters() {
        return Stream.of(((FunctionFBType)this.getType()).getInputParameters(), ((FunctionFBType)this.getType()).getInOutParameters(), ((FunctionFBType)this.getType()).getOutputParameters()).flatMap(Collection::stream).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast);
    }

    protected static CharSequence generateParameterTypeName(VarDeclaration variable, boolean output) {
        INamedElement type = VariableOperations.evaluateResultType((VarDeclaration)variable);
        return output ? ForteNgExportUtil.generateTypeNameAsParameter(type) : ForteNgExportUtil.generateTypeName(type);
    }

    public ILanguageSupport getBodyLanguageSupport() {
        return this.bodyLanguageSupport;
    }

    @Override
    public List<String> getErrors() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getErrors().stream(), this.bodyLanguageSupport.getErrors().stream()).toList();
        }
        return super.getErrors();
    }

    @Override
    public List<String> getWarnings() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getWarnings().stream(), this.bodyLanguageSupport.getWarnings().stream()).toList();
        }
        return super.getWarnings();
    }

    @Override
    public List<String> getInfos() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getInfos().stream(), this.bodyLanguageSupport.getInfos().stream()).toList();
        }
        return super.getInfos();
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getDependencies(options).stream(), this.bodyLanguageSupport.getDependencies(options).stream()).collect(Collectors.toSet());
        }
        return super.getDependencies(options);
    }
}

