/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.gef.editors.InitialValueEditor;
import org.eclipse.fordiac.ide.gef.widgets.PinInfoBasicWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVarConfigurationCommand;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PinInfoDataWidget
extends PinInfoBasicWidget {
    private InitialValueEditor initialValueEditor;
    private CLabel varConfigLabel;
    private Button varConfigCheckBox;

    public PinInfoDataWidget(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    public void initialize(IInterfaceElement type, Consumer<Command> commandExecutor) {
        super.initialize(type, commandExecutor);
        this.initialValueEditor.setInterfaceElement(type);
        this.initialValueEditor.setCommandExecutor(commandExecutor);
        this.setVarConfigOption(this.getType().isIsInput());
    }

    private void setVarConfigOption(boolean enabled) {
        this.varConfigLabel.setVisible(enabled);
        this.varConfigCheckBox.setVisible(enabled);
        this.varConfigCheckBox.setEnabled(enabled);
    }

    @Override
    public void refresh() {
        super.refresh();
        VarDeclaration type = this.getType();
        if (type != null) {
            Consumer commandExecutorBuffer = this.commandExecutor;
            this.commandExecutor = null;
            this.varConfigCheckBox.setSelection(type.isVarConfig());
            this.commandExecutor = commandExecutorBuffer;
        }
        this.initialValueEditor.refresh();
    }

    public VarDeclaration getType() {
        return (VarDeclaration)super.getType();
    }

    @Override
    protected void createWidget(Composite parent) {
        super.createWidget(parent);
        this.widgetFactory.createCLabel(parent, FordiacMessages.InitialValue + ":");
        this.initialValueEditor = new InitialValueEditor(parent, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.initialValueEditor.getControl());
        this.varConfigLabel = this.widgetFactory.createCLabel(parent, FordiacMessages.VarConfig + ":");
        this.varConfigCheckBox = this.widgetFactory.createButton(parent, null, 32);
        this.varConfigCheckBox.addListener(13, event -> this.executeCommand((Command)new ChangeVarConfigurationCommand(this.getType(), this.varConfigCheckBox.getSelection())));
    }

    @Override
    public void disableAllFields() {
        super.disableAllFields();
        this.initialValueEditor.setEditable(false);
    }

    @Override
    protected void checkFieldEnablements() {
        super.checkFieldEnablements();
        this.initialValueEditor.setEditable(this.isTypeChangeable());
        this.varConfigCheckBox.setEnabled(this.isEditable());
    }
}

