/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.globalconstantseditor.ui.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.PackageInfoWidget;
import org.eclipse.fordiac.ide.globalconstantseditor.ui.document.GlobalConstantsDocument;
import org.eclipse.fordiac.ide.globalconstantseditor.ui.editor.GlobalConstantsEditor;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class GlobalConstantsTypeInfoSection
extends AbstractSection {
    private PackageInfoWidget typeInfoWidget;
    private Text commentText;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createCommentField(parent);
        this.createTypeInfoGroup(parent);
    }

    private void createCommentField(Composite parent) {
        Composite container = this.getWidgetFactory().createComposite(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        container.setLayoutData((Object)data);
        this.getWidgetFactory().createLabel(container, FordiacMessages.Comment + ":");
        this.commentText = this.createGroupText(container, true);
        this.commentText.addModifyListener(e -> {
            if (!this.commentText.getText().equals(this.getType().getComment())) {
                this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            }
        });
    }

    private void createTypeInfoGroup(Composite parent) {
        this.typeInfoWidget = new PackageInfoWidget((FormToolkit)this.getWidgetFactory(), () -> ((GlobalConstantsTypeInfoSection)this).getAnnotationModel());
        this.typeInfoWidget.createControls(parent);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.setCurrentCommandStack(part, null);
        if (this.getCurrentCommandStack() == null) {
            this.setInputCode();
        }
        this.setType(part);
        this.setInputInit();
    }

    protected GlobalConstants getType() {
        return (GlobalConstants)this.type;
    }

    protected Object getInputType(Object input) {
        GlobalConstantsEditor editor;
        IXtextDocument iXtextDocument;
        if (input instanceof GlobalConstantsEditor && (iXtextDocument = (editor = (GlobalConstantsEditor)((Object)input)).getDocument()) instanceof GlobalConstantsDocument) {
            GlobalConstantsDocument document = (GlobalConstantsDocument)iXtextDocument;
            return document.getResourceLibraryElement();
        }
        return null;
    }

    protected void setInputCode() {
        this.commentText.setEnabled(false);
        this.typeInfoWidget.setEnabled(false);
    }

    protected void performRefresh() {
        this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
        this.typeInfoWidget.refresh();
    }

    protected void performRefreshAnnotations() {
        this.typeInfoWidget.refreshAnnotations();
    }

    protected void setInputInit() {
        this.typeInfoWidget.initialize((LibraryElement)this.getType(), arg_0 -> ((GlobalConstantsTypeInfoSection)this).executeCommand(arg_0));
    }
}

