/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.refactoring;

import java.util.EnumSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.ui.refactoring.AddLibraryDependencyChange;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class DeleteLibraryDependencyChange
extends CompositeChange
implements IFordiacPreviewChange {
    private final IProject project;
    private final String symbolicName;
    private final EnumSet<IFordiacPreviewChange.ChangeState> state = EnumSet.noneOf(IFordiacPreviewChange.ChangeState.class);

    public DeleteLibraryDependencyChange(IProject project, String symbolicName) {
        super(Messages.DeleteLibraryParticipant_Change_Title);
        this.project = project;
        this.symbolicName = symbolicName;
        this.state.addAll(this.getDefaultSelection());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.state.contains(IFordiacPreviewChange.ChangeState.DELETE)) {
            Manifest projectManifest = ManifestHelper.getContainerManifest((IContainer)this.project);
            if (projectManifest == null || projectManifest.getDependencies() == null) {
                return null;
            }
            Required dependency = projectManifest.getDependencies().getRequired().stream().filter(r -> this.symbolicName.equals(r.getSymbolicName())).findAny().orElse(null);
            if (dependency != null && ManifestHelper.removeDependency((Manifest)projectManifest, (Required)dependency) && ManifestHelper.saveManifest((Manifest)projectManifest)) {
                return new AddLibraryDependencyChange(this.project, dependency);
            }
        }
        return null;
    }

    public EnumSet<IFordiacPreviewChange.ChangeState> getState() {
        return this.state;
    }

    public EnumSet<IFordiacPreviewChange.ChangeState> getAllowedChoices() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.DELETE, IFordiacPreviewChange.ChangeState.NO_CHANGE);
    }

    public void addState(IFordiacPreviewChange.ChangeState newState) {
        this.state.add(newState);
    }

    public EnumSet<IFordiacPreviewChange.ChangeState> getDefaultSelection() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.DELETE);
    }
}

