/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapCommunicationCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.dataimport.MappingTargetCreator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationMappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class MapToCommand
extends Command
implements ScopedCommand {
    protected final FBNetworkElement srcElement;
    private final MappingTarget resource;
    private UnmapCommand unmapFromExistingTarget;
    protected FBNetworkElement targetElement;
    private final Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
    private final CompoundCommand createdConnections = new CompoundCommand();
    private int elementIndex = -1;

    protected MapToCommand(FBNetworkElement srcElement, MappingTarget resource) {
        this.srcElement = srcElement;
        this.resource = resource;
    }

    public boolean canExecute() {
        if (this.srcElement == null || this.resource == null) {
            return false;
        }
        if (this.srcElement.isMapped() && this.srcElement.getOpposite().getFbNetwork().equals(this.getTargetFBNetwork())) {
            ErrorMessenger.popUpErrorMessage((String)Messages.MapToCommand_STATUSMessage_AlreadyMapped);
            return false;
        }
        return true;
    }

    public void execute() {
        if (this.srcElement.isMapped()) {
            this.unmapFromExistingTarget = this.createUnmapCommand();
            this.unmapFromExistingTarget.execute();
        }
        this.targetElement = this.createTargetElement();
        this.mapping.setFrom(this.srcElement);
        this.mapping.setTo(this.targetElement);
        this.srcElement.setMapping(this.mapping);
        this.targetElement.setMapping(this.mapping);
        this.addMapping();
        this.checkConnections();
        this.createdConnections.execute();
    }

    protected UnmapCommand createUnmapCommand() {
        return new UnmapCommand(this.srcElement.getOpposite());
    }

    public void undo() {
        this.createdConnections.undo();
        this.srcElement.setMapping(null);
        this.targetElement.setMapping(null);
        this.removeMappedElements();
        this.getAutomationSystem().getMapping().remove((Object)this.mapping);
        if (this.unmapFromExistingTarget != null) {
            this.unmapFromExistingTarget.undo();
        }
    }

    protected void addMappedElements() {
        this.getTargetFBNetwork().getNetworkElements().add((Object)this.targetElement);
    }

    protected void removeMappedElements() {
        this.getTargetFBNetwork().getNetworkElements().remove((Object)this.targetElement);
    }

    public void redo() {
        if (this.unmapFromExistingTarget != null) {
            this.unmapFromExistingTarget.redo();
        }
        this.addMappedElements();
        this.srcElement.setMapping(this.mapping);
        this.targetElement.setMapping(this.mapping);
        this.addMapping();
        this.createdConnections.redo();
    }

    protected FBNetworkElement createTargetElement() {
        return MappingTargetCreator.createMappingTarget((Resource)((Resource)this.resource), (FBNetworkElement)this.srcElement, (String)this.srcElement.getName());
    }

    private AutomationSystem getAutomationSystem() {
        return this.srcElement.getFbNetwork().getApplication().getAutomationSystem();
    }

    protected void checkConnections() {
        List<IInterfaceElement> validInterfaceElements = this.srcElement.getInterface().getAllInterfaceElements().stream().filter(element -> !(element instanceof ErrorMarkerInterface)).toList();
        for (IInterfaceElement interfaceElement : validInterfaceElements) {
            if (interfaceElement.isIsInput()) {
                this.checkInputConnections(interfaceElement);
                continue;
            }
            this.checkOutputConnections(interfaceElement);
        }
    }

    private void checkInputConnections(IInterfaceElement interfaceElement) {
        Stream<Connection> inputConnections = interfaceElement.getInputConnections().stream().filter(connection -> !(connection.getSource() instanceof ErrorMarkerInterface));
        inputConnections.forEach(connection -> {
            Resource res = connection.getSourceElement().getResource();
            if (this.resource.equals(res)) {
                VarDeclaration varDeclaration;
                FBNetworkElement sourceElement;
                IInterfaceElement source;
                VarDeclaration varDeclaration2;
                IInterfaceElement destination = this.targetElement.getInterfaceElement(interfaceElement.getName());
                if (destination instanceof VarDeclaration && (varDeclaration2 = (VarDeclaration)destination).isInOutVar() && !varDeclaration2.isIsInput()) {
                    destination = varDeclaration2.getInOutVarOpposite();
                }
                if ((source = (sourceElement = connection.getSourceElement().getOpposite()).getInterfaceElement(connection.getSource().getName())) instanceof VarDeclaration && (varDeclaration = (VarDeclaration)source).isInOutVar() && varDeclaration.isIsInput()) {
                    source = varDeclaration.getInOutVarOpposite();
                }
                this.addConnectionCreateCommand(source, destination, connection.isVisible());
            }
        });
    }

    private void checkOutputConnections(IInterfaceElement interfaceElement) {
        Stream<Connection> outputConnections = interfaceElement.getOutputConnections().stream().filter(connection -> !MapToCommand.isSelfConnection(connection)).filter(connection -> !(connection.getDestination() instanceof ErrorMarkerInterface));
        outputConnections.forEach(connection -> {
            Resource res = connection.getDestinationElement().getResource();
            if (this.resource.equals(res)) {
                VarDeclaration varDeclaration;
                IInterfaceElement source;
                VarDeclaration varDeclaration2;
                FBNetworkElement destinationElement = connection.getDestinationElement();
                IInterfaceElement destination = destinationElement.getOpposite().getInterfaceElement(connection.getDestination().getName());
                if (destination instanceof VarDeclaration && (varDeclaration2 = (VarDeclaration)destination).isInOutVar() && !varDeclaration2.isIsInput()) {
                    destination = varDeclaration2.getInOutVarOpposite();
                }
                if ((source = this.targetElement.getInterfaceElement(interfaceElement.getName())) instanceof VarDeclaration && (varDeclaration = (VarDeclaration)source).isInOutVar() && varDeclaration.isIsInput()) {
                    source = varDeclaration.getInOutVarOpposite();
                }
                this.addConnectionCreateCommand(source, destination, connection.isVisible());
                if (destination instanceof AdapterDeclaration || destination instanceof VarDeclaration) {
                    this.checkForDeleteConnections(destination);
                }
            }
        });
    }

    private static boolean isSelfConnection(Connection connection) {
        return connection.getSourceElement() == connection.getDestinationElement();
    }

    private void addConnectionCreateCommand(IInterfaceElement source, IInterfaceElement destination, boolean visible) {
        AbstractConnectionCreateCommand cmd = this.getConnectionCreateCmd(source);
        if (cmd != null) {
            cmd.setSource(source);
            cmd.setDestination(destination);
            cmd.setVisible(visible);
            cmd.setPerformMappingCheck(false);
            this.createdConnections.add((Command)cmd);
        }
    }

    private void checkForDeleteConnections(IInterfaceElement destination) {
    }

    private AbstractConnectionCreateCommand getConnectionCreateCmd(IInterfaceElement interfaceElement) {
        if (interfaceElement instanceof Event) {
            return new EventConnectionCreateCommand(this.getTargetFBNetwork());
        }
        if (interfaceElement instanceof AdapterDeclaration) {
            return new AdapterConnectionCreateCommand(this.getTargetFBNetwork());
        }
        if (interfaceElement instanceof VarDeclaration) {
            return new DataConnectionCreateCommand(this.getTargetFBNetwork());
        }
        return null;
    }

    protected FBNetwork getTargetFBNetwork() {
        return ((Resource)this.resource).getFBNetwork();
    }

    public static Command createMapToCommand(FBNetworkElement srcElement, MappingTarget resource) {
        if (resource instanceof Resource) {
            if (srcElement instanceof Group) {
                Group group = (Group)srcElement;
                CompoundCommand cmd = new CompoundCommand();
                group.getGroupElements().forEach(el -> cmd.add((Command)new MapToCommand((FBNetworkElement)el, resource)));
                return cmd;
            }
            return new MapToCommand(srcElement, resource);
        }
        if (resource instanceof CommunicationMappingTarget) {
            CommunicationMappingTarget communicationMappingTarget = (CommunicationMappingTarget)resource;
            return new MapCommunicationCommand(srcElement, communicationMappingTarget);
        }
        return null;
    }

    private void addMapping() {
        if (this.elementIndex == -1) {
            this.getAutomationSystem().getMapping().add((Object)this.mapping);
        } else {
            this.getAutomationSystem().getMapping().add(this.elementIndex, (Object)this.mapping);
        }
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.srcElement != null && this.resource != null) {
            return Set.of(this.srcElement, this.resource);
        }
        return Set.of();
    }

    public void setElementIndex(int elementIndex) {
        this.elementIndex = elementIndex;
    }
}

