/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.providers;

import org.eclipse.fordiac.ide.model.edit.providers.BoldStyler;
import org.eclipse.fordiac.ide.model.edit.providers.TypeImageProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ResultListLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private String[] searchString;

    public ResultListLabelProvider(String searchString) {
        this.setSearchString(searchString);
    }

    public ResultListLabelProvider() {
        this.setSearchString("");
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            StyledString styledString = ResultListLabelProvider.getTypeEntryStyledText(entry);
            int lastIndex = 0;
            String[] stringArray = this.searchString;
            int n = this.searchString.length;
            int n2 = 0;
            while (n2 < n) {
                String searchStringElement = stringArray[n2];
                int offset = styledString.toString().toUpperCase().indexOf(searchStringElement.toUpperCase(), lastIndex);
                if (offset >= 0) {
                    styledString.setStyle(offset, searchStringElement.length(), (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
                    lastIndex = offset + searchStringElement.length();
                }
                ++n2;
            }
            return styledString;
        }
        if (element != null) {
            return new StyledString(element.toString());
        }
        return new StyledString();
    }

    public static StyledString getTypeEntryStyledText(TypeEntry entry) {
        StyledString styledString = new StyledString(entry.getTypeName());
        String packageName = entry.getPackageName();
        if (!packageName.isEmpty()) {
            styledString.append(" - " + packageName, StyledString.DECORATIONS_STYLER);
        }
        styledString.append(" - " + entry.getComment(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    public Image getImage(Object element) {
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            return TypeImageProvider.getImageForTypeEntry(entry);
        }
        return null;
    }

    public String getText(Object element) {
        String string;
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            string = String.format("%s - %s", this.getStyledText(element).toString(), entry.getFile().getFullPath());
        } else {
            string = "-";
        }
        return string;
    }

    public void setSearchString(String searchString) {
        this.searchString = new String[]{searchString};
        this.validateSearchString();
    }

    private void validateSearchString() {
        this.searchString = this.searchString[0].split("[\\*\\?]+", -1);
        int i = 0;
        while (i < this.searchString.length) {
            this.searchString[i] = this.searchString[i].replaceAll("\\W", "");
            ++i;
        }
    }
}

