/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.model.search.ModelSearchTableContentProvider;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ModelSearchResultPage
extends AbstractTextSearchViewPage {
    private static final String ID = "org.eclipse.fordiac.ide.model.search.ModelSearchResultPage";
    private ModelSearchTableContentProvider contentProvider;
    private String searchDescription;
    private static final int TYPE_COLUMN_WIDTH = 100;
    private static final int NAME_COMMENT_COLUMN_WIDTH = 200;
    private static final int FULL_HIERARCHICAL_NAME_COLUMN_WIDTH = 300;
    private static final String FULL_NAME_COLUMN = "Full Hierarchical Name";

    public ModelSearchResultPage() {
        super(1);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getID() {
        return ID;
    }

    public String getLabel() {
        return this.searchDescription != null ? this.searchDescription : Messages.SearchHeaderName;
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
        if (newSearch != null) {
            this.searchDescription = newSearch.getLabel();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 66306);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new ModelSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)ModelSearchResultPage.createTableLayout());
        TableViewerColumn colKind = new TableViewerColumn(viewer, 16384);
        colKind.getColumn().setText("Element Kind");
        colKind.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String kind = element.getClass().getSimpleName();
                return kind.substring(0, kind.length() - 4);
            }
        });
        TableViewerColumn colName = new TableViewerColumn(viewer, 16384);
        colName.getColumn().setText(FordiacMessages.Name);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof INamedElement) {
                    INamedElement ne = (INamedElement)element;
                    return ne.getName();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colComment = new TableViewerColumn(viewer, 16384);
        colComment.getColumn().setText(FordiacMessages.Comment);
        colComment.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof INamedElement) {
                    INamedElement ne = (INamedElement)element;
                    return ne.getComment();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colType = new TableViewerColumn(viewer, 16384);
        colType.getColumn().setText(FordiacMessages.Type);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBType) {
                    FBType fbType = (FBType)element;
                    return fbType.getName();
                }
                if (element instanceof TypedConfigureableObject) {
                    TypedConfigureableObject to = (TypedConfigureableObject)element;
                    LibraryElement type = to.getType();
                    return type != null ? type.getName() : "untyped";
                }
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ie = (IInterfaceElement)element;
                    DataType type = ie.getType();
                    return type != null ? type.getName() : "unknown";
                }
                if (element instanceof Algorithm) {
                    return "Algorithm";
                }
                if (element instanceof Method) {
                    return "Method";
                }
                if (element instanceof INamedElement) {
                    INamedElement namedElement = (INamedElement)element;
                    return namedElement.getName();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn fullHierarchicalName = new TableViewerColumn(viewer, 16384);
        fullHierarchicalName.getColumn().setText(FULL_NAME_COLUMN);
        fullHierarchicalName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ModelSearchResult searchResult = (ModelSearchResult)ModelSearchResultPage.this.contentProvider.getSearchResult();
                return searchResult.getDictionary().hierarchicalName(element);
            }
        });
    }

    private static void jumpToBlock(OpenEvent doubleClick) {
        Object selection;
        StructuredSelection selectionList = (StructuredSelection)doubleClick.getSelection();
        if (!selectionList.isEmpty() && (selection = selectionList.getFirstElement()) instanceof EObject) {
            EObject eobj = (EObject)selection;
            ModelSearchResultPage.jumpHelper(eobj);
        }
    }

    private static void jumpHelper(EObject jumpingTo) {
        IEditorPart editor = OpenListenerManager.openEditor((EObject)ModelSearchResultPage.getParent(jumpingTo));
        if (editor instanceof ISelectionListener) {
            ISelectionListener listener = (ISelectionListener)editor;
            listener.selectionChanged((IWorkbenchPart)editor, (ISelection)new StructuredSelection((Object)EcoreUtil.getURI((EObject)jumpingTo)));
        } else {
            GraphicalViewer viewer = HandlerHelper.getViewer((IEditorPart)editor);
            HandlerHelper.selectElement((Object)jumpingTo, (GraphicalViewer)viewer);
        }
    }

    private static EObject getParent(EObject eobj) {
        SubApp subApp;
        if (eobj instanceof Device) {
            Device dev = (Device)eobj;
            return dev.getPosition().eContainer().eContainer();
        }
        if (eobj instanceof Application || eobj instanceof FBType) {
            return eobj;
        }
        FBNetworkElement parent = null;
        if (eobj instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)eobj;
            parent = ie.getFBNetworkElement();
            if (parent != null) {
                parent = parent.eContainer().eContainer();
            } else {
                parent = ie.eContainer();
                if (parent.eContainer() != null) {
                    parent = parent.eContainer();
                }
            }
        } else if (ModelSearchResultPage.isInternalFb(eobj)) {
            parent = eobj.eContainer();
        } else if (eobj instanceof Algorithm || eobj instanceof Method) {
            parent = eobj.eContainer();
        } else {
            if (eobj.eContainer() == null) {
                return eobj;
            }
            parent = eobj.eContainer().eContainer();
        }
        while (parent instanceof SubApp && (subApp = (SubApp)parent).isUnfolded()) {
            parent = subApp.eContainer().eContainer();
        }
        return parent;
    }

    private static boolean isInternalFb(EObject eobj) {
        FB fb;
        return eobj instanceof FB && (fb = (FB)eobj).eContainer() instanceof FBType && !fb.isContainedInTypedInstance();
    }

    protected static TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(300));
        return layout;
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void handleOpen(OpenEvent event) {
        ModelSearchResultPage.jumpToBlock(event);
    }

    public static void showResult(EObject obj) {
        EObject toOpen = obj;
        if (obj instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)obj;
            toOpen = ie.getFBNetworkElement();
        }
        if (obj instanceof SubApp) {
            toOpen = ((SubApp)toOpen).getOuterFBNetworkElement();
        }
        if (toOpen instanceof FBNetworkElement) {
            FBNetworkElement fbne = (FBNetworkElement)toOpen;
            IEditorPart p = HandlerHelper.openParentEditor((FBNetworkElement)fbne);
            HandlerHelper.selectElement((Object)obj, (IEditorPart)p);
        }
        HandlerHelper.openEditor((EObject)obj);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        ShowInEditorAction showInEditor = new ShowInEditorAction(this);
        mgr.prependToGroup("group.show", (IAction)showInEditor);
        super.fillContextMenu(mgr);
    }

    private static class ShowInEditorAction
    extends Action {
        private final ModelSearchResultPage fPage;

        public ShowInEditorAction(AbstractTextSearchViewPage page) {
            super("Show in Editor");
            this.setToolTipText("Shows element in the editor");
            this.fPage = (ModelSearchResultPage)page;
        }

        public void run() {
            ModelSearchResultPage.showResult((EObject)this.fPage.getViewer().getStructuredSelection().getFirstElement());
        }
    }
}

