/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.cleanup;

import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.structuredtextcore.ui.cleanup.STCoreSaveActionsPreferences;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class STCoreCleanupEditorCallback
extends IXtextEditorCallback.NullImpl {
    @Inject
    private STCoreSaveActionsPreferences preferences;
    @Inject(optional=true)
    private IContentFormatterFactory contentFormatterFactory;
    private boolean running = false;

    public void afterSave(XtextEditor editor) {
        if (!this.running && this.preferences.isEnableSaveActions()) {
            try {
                this.running = true;
                this.performSaveActions(editor);
                if (editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                this.running = false;
            }
        }
    }

    protected void performSaveActions(XtextEditor editor) {
        if (this.preferences.isEnableFormat()) {
            this.performFormat(editor);
        }
    }

    protected void performFormat(XtextEditor editor) {
        if (this.contentFormatterFactory == null) {
            return;
        }
        IContentFormatter formatter = this.contentFormatterFactory.createConfiguredFormatter(null, null);
        XtextDocument document = (XtextDocument)editor.getDocument();
        String savedContents = document.get();
        DocumentRewriteSession rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        try {
            try {
                formatter.format((IDocument)document, (IRegion)new Region(0, document.getLength()));
            }
            catch (Exception e) {
                document.set(savedContents);
                throw e;
            }
        }
        finally {
            document.stopRewriteSession(rewriteSession);
        }
    }
}

