/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InLayerConstraint;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InLayerConstraintProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer constraint edge reversal", 1.0f);
        for (Layer layer : layeredGraph) {
            int topInsertionIndex = -1;
            ArrayList bottomConstrainedNodes = Lists.newArrayList();
            LNode[] nodes = LGraphUtil.toNodeArray(layer.getNodes());
            int i = 0;
            while (i < nodes.length) {
                InLayerConstraint constraint = (InLayerConstraint)((Object)nodes[i].getProperty(InternalProperties.IN_LAYER_CONSTRAINT));
                if (topInsertionIndex == -1) {
                    if (constraint != InLayerConstraint.TOP) {
                        topInsertionIndex = i;
                    }
                } else if (constraint == InLayerConstraint.TOP) {
                    nodes[i].setLayer(null);
                    nodes[i].setLayer(topInsertionIndex++, layer);
                }
                if (constraint == InLayerConstraint.BOTTOM) {
                    bottomConstrainedNodes.add(nodes[i]);
                }
                ++i;
            }
            for (LNode node : bottomConstrainedNodes) {
                node.setLayer(null);
                node.setLayer(layer);
            }
        }
        monitor.done();
    }
}

