/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.fordiac.ide.debug.CommonEvaluatorDebugger;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugThread;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.IEvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.Messages;
import org.eclipse.fordiac.ide.debug.breakpoint.EvaluatorLineBreakpoint;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorDebugger;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class EvaluatorDebugTarget
extends EvaluatorDebugElement
implements IEvaluatorDebugTarget {
    private final String name;
    private final ILaunch launch;
    private final IResource resource;
    private final EvaluatorProcess process;
    private final CommonEvaluatorDebugger debugger;
    private final AtomicLong variableUpdateCount = new AtomicLong();

    public EvaluatorDebugTarget(String name, Evaluator evaluator, ILaunch launch, IResource resource) throws CoreException {
        super(null);
        this.name = name;
        this.launch = launch;
        this.resource = resource;
        this.process = new EvaluatorProcess(name, evaluator, launch);
        this.debugger = new CommonEvaluatorDebugger(this);
        this.process.getExecutor().attachDebugger((EvaluatorDebugger)this.debugger);
        this.process.getExecutor().addMonitor((EvaluatorMonitor)new EvaluatorVariableMonitor());
        launch.addDebugTarget((IDebugTarget)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        Stream.of(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints()).forEachOrdered(this::breakpointAdded);
        this.fireCreationEvent();
    }

    public void start() {
        this.process.start();
    }

    public void terminated() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fireTerminateEvent();
    }

    public CommonEvaluatorDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public long getVariableUpdateCount() {
        return this.variableUpdateCount.get();
    }

    public long incrementVariableUpdateCount() {
        return this.variableUpdateCount.incrementAndGet();
    }

    @Override
    public TypeLibrary getTypeLibrary() {
        return TypeLibraryManager.INSTANCE.getTypeLibrary(this.resource.getProject());
    }

    public boolean canResume() {
        return this.debugger.getThreads().stream().anyMatch(EvaluatorDebugThread::canResume);
    }

    public boolean canSuspend() {
        return this.debugger.getThreads().stream().anyMatch(EvaluatorDebugThread::canSuspend);
    }

    public boolean isSuspended() {
        return this.debugger.getThreads().stream().allMatch(EvaluatorDebugThread::isSuspended);
    }

    public void resume() throws DebugException {
        for (EvaluatorDebugThread thread : this.debugger.getThreads()) {
            thread.resume();
        }
    }

    public void suspend() throws DebugException {
        for (EvaluatorDebugThread thread : this.debugger.getThreads()) {
            thread.suspend();
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof EvaluatorLineBreakpoint;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.debugger.addBreakpoint(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.debugger.removeBreakpoint(breakpoint, delta);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.debugger.updateBreakpoint(breakpoint, delta);
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return this.process.canTerminate();
    }

    public boolean isTerminated() {
        return this.process.isTerminated();
    }

    public void terminate() throws DebugException {
        this.process.terminate();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        throw new DebugException(Status.error((String)"Disconnect is not supported"));
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException(Status.error((String)"Getting memory blocks is not supported"));
    }

    public EvaluatorProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        List<EvaluatorDebugThread> threads = this.debugger.getThreads();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.debugger.getThreads().isEmpty();
    }

    private class EvaluatorVariableMonitor
    extends Job
    implements EvaluatorMonitor {
        private static final int UPDATE_INTERVAL = 200;
        private final AtomicReference<Set<Variable<?>>> queue;

        protected IStatus run(IProgressMonitor monitor) {
            EvaluatorDebugTarget.this.incrementVariableUpdateCount();
            DebugEvent[] events = (DebugEvent[])((Set)this.queue.getAndSet(ConcurrentHashMap.newKeySet())).stream().map(EvaluatorDebugTarget.this.debugger::getVariable).map(variable -> new DebugEvent(variable, 16, 512)).toArray(DebugEvent[]::new);
            if (events.length != 0) {
                DebugPlugin.getDefault().fireDebugEventSet(events);
            }
            return Status.OK_STATUS;
        }

        public EvaluatorVariableMonitor() {
            super(MessageFormat.format(Messages.EvaluatorDebugTarget_UpdateVariablesJobName, EvaluatorDebugTarget.this.name));
            this.queue = new AtomicReference(ConcurrentHashMap.newKeySet());
        }

        public void update(Collection<? extends Variable<?>> variables, Evaluator evaluator) {
            if (!variables.isEmpty() && evaluator.isPersistent()) {
                this.queue.get().addAll(variables);
                this.schedule(200L);
            }
        }

        public void info(String message) {
        }

        public void warn(String message) {
        }

        public void error(String message) {
        }

        public void error(String message, Throwable t) {
        }

        public void terminated(EvaluatorThreadPoolExecutor executor) {
        }
    }
}

