/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.value;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.IEvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugStructuredValue;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;

public final class EvaluatorDebugArrayValue
extends EvaluatorDebugStructuredValue
implements IIndexedValue {
    private final List<EvaluatorDebugVariable> elements;

    public EvaluatorDebugArrayValue(ArrayValue value, String expression, IEvaluatorDebugTarget target) {
        super((Value)value, target);
        this.elements = IntStream.rangeClosed(value.getStart(), value.getEnd()).mapToObj(index -> target.createVariable(value.get(index), EvaluatorDebugArrayValue.createSubExpression(expression, index))).toList();
    }

    public EvaluatorDebugArrayValue(ArrayValue value, EvaluatorDebugVariable variable) {
        super((Value)value, variable);
        this.elements = IntStream.rangeClosed(value.getStart(), value.getEnd()).mapToObj(index -> variable.createSubVariable(value.get(index), EvaluatorDebugArrayValue.createSubExpression(variable.getExpression(), index))).toList();
    }

    public ArrayValue getInternalValue() {
        return (ArrayValue)super.getInternalValue();
    }

    @Override
    public EvaluatorDebugVariable getVariable(String name) {
        return null;
    }

    @Override
    public IVariable[] getVariables() {
        return (IVariable[])this.elements.toArray(IVariable[]::new);
    }

    @Override
    public boolean hasVariables() {
        return true;
    }

    public IVariable getVariable(int offset) throws DebugException {
        try {
            return this.elements.get(offset - this.getInitialOffset());
        }
        catch (IndexOutOfBoundsException e) {
            throw new DebugException(Status.error((String)("Cannot get variable at index " + offset), (Throwable)e));
        }
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        try {
            return (IVariable[])this.elements.subList(offset - this.getInitialOffset(), offset + length - this.getInitialOffset()).toArray(IVariable[]::new);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DebugException(Status.error((String)("Cannot get variables from index " + offset + " to " + (offset + length)), (Throwable)e));
        }
    }

    public int getSize() throws DebugException {
        return this.getInternalValue().getElements().size();
    }

    public int getInitialOffset() {
        return this.getInternalValue().getStart();
    }
}

