/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gitlab.treeviewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.fordiac.ide.gitlab.Package;
import org.eclipse.fordiac.ide.gitlab.Project;
import org.eclipse.fordiac.ide.gitlab.treeviewer.LeafNode;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class GLTreeContentProvider
implements ITreeContentProvider {
    private Map<Project, List<Package>> projectsAndPackages;
    private final Map<String, List<LeafNode>> packagesAndLeaves;

    public GLTreeContentProvider(Map<String, List<LeafNode>> packagesAndLeaves) {
        this.packagesAndLeaves = packagesAndLeaves;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof HashMap) {
            this.projectsAndPackages = (HashMap)inputElement;
            return this.projectsAndPackages.keySet().toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Project) {
            return ((List)((HashMap)this.projectsAndPackages).get(parentElement)).stream().filter(GLTreeContentProvider.distinctByPackageName(Package::name)).toArray();
        }
        if (parentElement instanceof Package) {
            Package pack = (Package)parentElement;
            return this.packagesAndLeaves.get(pack.name()).toArray();
        }
        return new String[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Package) {
            Object[] parent = new Object[1];
            this.projectsAndPackages.forEach((key, value) -> {
                if (value.contains(element)) {
                    objectArray[0] = key;
                }
            });
            return parent[0];
        }
        if (element instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)element;
            return leafNode.getPackage();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Package pack;
        return element instanceof Project && !this.projectsAndPackages.get(element).isEmpty() || element instanceof Package && !this.packagesAndLeaves.get((pack = (Package)element).name()).isEmpty();
    }

    private static <T> Predicate<T> distinctByPackageName(Function<? super T, ?> nameExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(nameExtractor.apply(t));
    }
}

