/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.syntaxcoloring;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultAntlrTokenToAttributeIdMapper;

public class STCoreAntlrTokenToAttributeIdMapper
extends DefaultAntlrTokenToAttributeIdMapper {
    private static final Set<String> VAR_DECLARATION_KEYWORDS = Set.of("'VAR'", "'VAR_TEMP'", "'VAR_INPUT'", "'VAR_OUTPUT'", "'VAR_IN_OUT'", "'END_VAR'", "'VAR_EXTERNAL'", "'VAR_GLOBAL'", "'VAR_ACCESS'", "'RETAIN'", "'CONSTANT'", "'AT'");
    private static final Set<String> DATA_TYPES_KEYWORDS = DataTypeLibrary.getNonUserDefinedDataTypes().stream().map(INamedElement::getName).map(name -> "'" + name + "'").collect(Collectors.toUnmodifiableSet());
    private static final Set<String> FUNCTIONS_KEYWORDS = Set.of("'FUNCTION'", "'END_FUNCTION'");
    private static final Set<String> FUNCTION_BLOCK_KEYWORDS = Set.of("'FUNCTION_BLOCK'", "'END_FUNCTION_BLOCK'");
    private static final Set<String> METHOD_BLOCK_KEYWORDS = Set.of("'METHOD'", "'END_METHOD'");
    private static final Set<String> ALGORITHM_BLOCK_KEYWORDS = Set.of("'ALGORITHM'", "'END_ALGORITHM'");
    private static final Set<String> BOOLEAN_KEYWORDS = Set.of("'TRUE'", "'FALSE'");

    protected String calculateId(String tokenName, int tokenType) {
        if (VAR_DECLARATION_KEYWORDS.contains(tokenName)) {
            return "VarKeyword";
        }
        if (DATA_TYPES_KEYWORDS.contains(tokenName)) {
            return "DataType";
        }
        if (FUNCTION_BLOCK_KEYWORDS.contains(tokenName)) {
            return "FunctionBlock";
        }
        if (METHOD_BLOCK_KEYWORDS.contains(tokenName)) {
            return "MethodBlock";
        }
        if (ALGORITHM_BLOCK_KEYWORDS.contains(tokenName)) {
            return "AlgorithmBlock";
        }
        if (FUNCTIONS_KEYWORDS.contains(tokenName)) {
            return "Functions";
        }
        if (BOOLEAN_KEYWORDS.contains(tokenName)) {
            return "number";
        }
        return super.calculateId(tokenName, tokenType);
    }
}

