/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.issuereport.GitIssueCreator;
import org.eclipse.fordiac.ide.issuereport.PreferenceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class FordiacLogListener
implements ILogListener {
    private final AtomicBoolean singleWindow = new AtomicBoolean();

    public void logging(IStatus status, String plugin) {
        if (status.getSeverity() == 4 && status.getException() != null && (status.getPlugin().startsWith("org.eclipse.fordiac.ide") || status.getPlugin().equals("org.eclipse.ui")) && !this.singleWindow.getAndSet(true)) {
            try {
                FordiacLogListener.showErrorDialog(FordiacLogListener.createStatusWithStackTrace(status));
            }
            finally {
                this.singleWindow.set(false);
            }
        }
    }

    private static IStatus createStatusWithStackTrace(IStatus status) {
        String stackTrace = FordiacLogListener.getStackTrace(status.getException());
        IStatus[] stackList = (IStatus[])Arrays.stream(stackTrace.split(System.getProperty("line.separator"))).map(l -> new Status(4, status.getPlugin(), l)).toArray(IStatus[]::new);
        return new MultiStatus(status.getPlugin(), 4, stackList, status.getMessage(), status.getException());
    }

    private static String getStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static void showErrorDialog(IStatus displayStatus) {
        if (Display.getCurrent() != null && Display.getCurrent().getActiveShell() != null) {
            new LogErrorDialog(Display.getCurrent().getActiveShell(), displayStatus).open();
        }
    }

    private static final class LogErrorDialog
    extends ErrorDialog {
        private final IStatus status;
        private Link reportInfo;

        private LogErrorDialog(Shell parentShell, IStatus status) {
            super(parentShell, Messages.FordiacLogListener_ErrorDialogTitle, Messages.FordiacLogListener_ErrorDialogRestartSave, status, 7);
            this.status = status;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.reportInfo = new Link(parent, 0);
            this.reportInfo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GitIssueCreator.openLinkInBrowser(e.text);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (PreferenceConstants.getReportMode() == PreferenceConstants.ReportMode.AUTO_REPORT) {
                this.report();
            } else {
                this.reportInfo.setText(Messages.FordiacLogListener_ErrorDialogReportPrompt);
            }
            return control;
        }

        private void report() {
            this.reportInfo.setText(Messages.FordiacLogListener_ReportInProgress);
            new Thread(() -> {
                Optional<String> url = GitIssueCreator.createIssue(this.status);
                Display.getDefault().asyncExec(() -> {
                    if (this.reportInfo == null || this.reportInfo.isDisposed()) {
                        return;
                    }
                    if (PreferenceConstants.getReportDestination() == PreferenceConstants.ReportDestination.GITHUB_MANUAL) {
                        this.reportInfo.setText(Messages.FordiacLogListener_BrowserOpened);
                    } else if (url.isEmpty()) {
                        this.reportInfo.setText(Messages.FordiacLogListener_ReportingError);
                    } else {
                        this.reportInfo.setText(Messages.FordiacLogListener_ReportingResult.formatted(url.get()));
                    }
                    this.reportInfo.requestLayout();
                });
            }).start();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            switch (PreferenceConstants.getReportMode()) {
                case AUTO_REPORT: {
                    this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    break;
                }
                case PROMPT_REPORT: {
                    Button rep = this.createButton(parent, 2, Messages.FordiacLogListener_ErrorDialogReportIssue, true);
                    rep.addListener(13, e -> {
                        rep.setEnabled(false);
                        this.report();
                    });
                    this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
                    break;
                }
                default: {
                    this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
                }
            }
            this.createDetailsButton(parent);
        }
    }
}

