/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.graph.IGraphConsumer;

public class ModelResolverDescriptor {
    private final IConfigurationElement configurationElement;
    private final String resolverClassPropertyName;
    private final int ranking;
    private final String label;
    private final String description;
    private final String className;
    private IModelResolver resolver;
    private boolean logOnce;

    ModelResolverDescriptor(IConfigurationElement configurationElement, String resolverClassPropertyName, int ranking, String label, String description) {
        this.configurationElement = (IConfigurationElement)Preconditions.checkNotNull((Object)configurationElement);
        this.resolverClassPropertyName = (String)Preconditions.checkNotNull((Object)resolverClassPropertyName);
        this.className = (String)Preconditions.checkNotNull((Object)configurationElement.getAttribute(resolverClassPropertyName));
        this.ranking = ranking;
        this.label = label == null ? this.className : label;
        this.description = Strings.nullToEmpty((String)description);
    }

    public int getRanking() {
        return this.ranking;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    IModelResolver getModelResolver() {
        block4: {
            if (this.resolver == null) {
                try {
                    this.resolver = (IModelResolver)this.configurationElement.createExecutableExtension(this.resolverClassPropertyName);
                    if (this.resolver instanceof IGraphConsumer) {
                        EMFCompareRCPPlugin.getDefault().register((IGraphConsumer)this.resolver);
                    }
                    this.resolver.initialize();
                }
                catch (CoreException e) {
                    if (this.logOnce) break block4;
                    this.logOnce = true;
                    String message = EMFCompareIDEUIMessages.getString("ModelResolverRegistry.invalidResolver", this.label);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.resolver;
    }

    void dispose() {
        if (this.resolver != null) {
            this.resolver.dispose();
        }
    }
}

