/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.nat.AbstractAnnotatedConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.TypedElementTableColumn;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class TypedElementConfigLabelAccumulator<T extends ITypedElement>
extends AbstractAnnotatedConfigLabelAccumulator<T> {
    private final List<TypedElementTableColumn> columns;

    public TypedElementConfigLabelAccumulator(IRowDataProvider<T> dataProvider) {
        this(dataProvider, () -> null);
    }

    public TypedElementConfigLabelAccumulator(IRowDataProvider<T> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        this(dataProvider, annotationModelSupplier, TypedElementTableColumn.DEFAULT_COLUMNS);
    }

    public TypedElementConfigLabelAccumulator(IRowDataProvider<T> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier, List<TypedElementTableColumn> columns) {
        super(dataProvider, annotationModelSupplier);
        this.columns = columns;
    }

    public List<TypedElementTableColumn> getColumns() {
        return this.columns;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        ITypedElement rowItem = (ITypedElement)this.getDataProvider().getRowObject(rowPosition);
        switch (this.columns.get(columnPosition)) {
            case NAME: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetName);
                break;
            }
            case TYPE: {
                configLabels.addLabel("PROPOSAL_CELL");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetType);
                break;
            }
            case COMMENT: {
                configLabels.addLabelOnTop("NONE_NULL");
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                if (CommentHelper.hasComment((INamedElement)rowItem)) break;
                configLabels.addLabelOnTop("DEFAULT_CELL");
                break;
            }
        }
    }
}

