/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.change.AbstractUpdateBlockFBNElementCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class ChangeStructCommand
extends AbstractUpdateBlockFBNElementCommand {
    private final TypeEntry newStructTypeEntry;
    private final String newVisibleChildren;
    private boolean reloadDatatype = true;

    public ChangeStructCommand(BlockFBNetworkElement fb, DataType newStruct) {
        super(fb);
        this.newStructTypeEntry = newStruct != null ? newStruct.getTypeEntry() : null;
        this.entry = fb.getTypeEntry();
        this.newVisibleChildren = null;
    }

    public ChangeStructCommand(StructManipulator mux) {
        this(mux, mux.getDataType(), ChangeStructCommand.getOldVisibleChildren(mux));
    }

    public ChangeStructCommand(StructManipulator mux, DataType newStruct) {
        this(mux, newStruct, ChangeStructCommand.getOldVisibleChildren(mux));
    }

    public ChangeStructCommand(StructManipulator mux, DataType newStruct, String visibleChildren, boolean doNotReload) {
        this(mux, newStruct, visibleChildren);
        this.reloadDatatype = !doNotReload;
    }

    public ChangeStructCommand(StructManipulator mux, DataType newStruct, boolean doNotReload) {
        this(mux, newStruct, ChangeStructCommand.getOldVisibleChildren(mux));
        this.reloadDatatype = !doNotReload;
    }

    public ChangeStructCommand(Demultiplexer demux, String newVisibleChildren) {
        this((StructManipulator)demux, demux.getDataType(), newVisibleChildren);
    }

    private ChangeStructCommand(StructManipulator demux, DataType datatype, String newVisibleChildren) {
        super((BlockFBNetworkElement)demux);
        this.newStructTypeEntry = datatype != null ? datatype.getTypeEntry() : null;
        this.entry = demux.getTypeEntry();
        this.newVisibleChildren = newVisibleChildren;
    }

    private static String getOldVisibleChildren(StructManipulator mux) {
        Demultiplexer demux;
        if (mux instanceof Demultiplexer && (demux = (Demultiplexer)mux).isIsConfigured()) {
            return ConfigurableFBManagement.buildVisibleChildrenString((EList)demux.getMemberVars());
        }
        return null;
    }

    @Override
    protected BlockFBNetworkElement createCopiedFBEntry(BlockFBNetworkElement srcElement) {
        Multiplexer copy = null;
        if (srcElement instanceof Multiplexer) {
            copy = LibraryElementFactory.eINSTANCE.createMultiplexer();
        } else if (srcElement instanceof Demultiplexer) {
            copy = LibraryElementFactory.eINSTANCE.createDemultiplexer();
        } else if (srcElement instanceof ConfigurableFB) {
            copy = LibraryElementFactory.eINSTANCE.createConfigurableMoveFB();
        }
        if (copy != null) {
            copy.setTypeEntry(this.entry);
        }
        return copy;
    }

    @Override
    protected void handleConfigurableFB() {
        ConfigurableFB confFB;
        BlockFBNetworkElement blockFBNetworkElement;
        if (this.newStructTypeEntry != null) {
            if (this.getNewElement() instanceof StructManipulator) {
                this.getNewMux().setDataType(this.getDataTypeFromTypeEntry());
            } else {
                blockFBNetworkElement = this.getNewElement();
                if (blockFBNetworkElement instanceof ConfigurableFB) {
                    confFB = (ConfigurableFB)blockFBNetworkElement;
                    confFB.setDataType(this.getDataTypeFromTypeEntry());
                }
            }
        }
        if (this.isDemuxConfiguration()) {
            this.getNewMux().loadConfiguration("VisibleChildren", this.newVisibleChildren);
        } else {
            blockFBNetworkElement = this.getNewElement();
            if (blockFBNetworkElement instanceof ConfigurableFB) {
                confFB = (ConfigurableFB)blockFBNetworkElement;
                confFB.updateConfiguration();
            }
        }
    }

    private boolean isDemuxConfiguration() {
        BlockFBNetworkElement blockFBNetworkElement = this.newElement;
        if (blockFBNetworkElement instanceof Demultiplexer) {
            Demultiplexer demux = (Demultiplexer)blockFBNetworkElement;
            return demux.isIsConfigured() || this.newVisibleChildren != null;
        }
        return false;
    }

    public StructManipulator getNewMux() {
        return (StructManipulator)this.newElement;
    }

    public StructManipulator getOldMux() {
        return (StructManipulator)this.oldElement;
    }

    private DataType getDataTypeFromTypeEntry() {
        StructuredType structuredType;
        if (this.newStructTypeEntry == null) {
            return IecTypes.GenericTypes.ANY_STRUCT;
        }
        Object type = this.reloadDatatype ? this.newStructTypeEntry.getTypeLibrary().getDataTypeLibrary().getType(this.newStructTypeEntry.getFullTypeName()) : this.newStructTypeEntry.getType();
        if (type instanceof DataType) {
            DataType dt = (DataType)type;
            structuredType = dt;
        } else {
            structuredType = IecTypes.GenericTypes.ANY_STRUCT;
        }
        return structuredType;
    }
}

