/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;

public final class ConnectionsHelper {
    public static EList<Connection> getConnections(IInterfaceElement oppositeIE) {
        IInterfaceElement fbOppostiteIE = oppositeIE.getBlockFBNetworkElement().getOpposite().getInterface().getInterfaceElement(oppositeIE);
        if (fbOppostiteIE != null) {
            return fbOppostiteIE.isIsInput() ? fbOppostiteIE.getInputConnections() : fbOppostiteIE.getOutputConnections();
        }
        return ECollections.emptyEList();
    }

    public static IInterfaceElement getOppositeInterfaceElement(IInterfaceElement ie, Connection connection) {
        IInterfaceElement fbOppostiteIE = ie.getBlockFBNetworkElement().getOpposite().getInterface().getInterfaceElement(ie);
        if (fbOppostiteIE != null) {
            IInterfaceElement connectionOpposite;
            IInterfaceElement iInterfaceElement = connectionOpposite = fbOppostiteIE.isIsInput() ? connection.getSource() : connection.getDestination();
            if (connectionOpposite != null && connectionOpposite.getBlockFBNetworkElement().isMapped()) {
                BlockFBNetworkElement mappedOppositeElement = connectionOpposite.getBlockFBNetworkElement().getOpposite();
                return mappedOppositeElement.getInterface().getInterfaceElement(connectionOpposite);
            }
        }
        return null;
    }

    public static Connection getOppositeConnection(Connection connection) {
        if (connection != null) {
            IInterfaceElement source = connection.getSource();
            IInterfaceElement dest = connection.getDestination();
            if (source != null && source.getBlockFBNetworkElement() != null && dest != null && dest.getBlockFBNetworkElement() != null) {
                BlockFBNetworkElement opSource = source.getBlockFBNetworkElement().getOpposite();
                BlockFBNetworkElement opDestination = dest.getBlockFBNetworkElement().getOpposite();
                if (opSource != null && opDestination != null && opSource.getFbNetwork() == opDestination.getFbNetwork()) {
                    IInterfaceElement opSourceIE = opSource.getInterface().getInterfaceElement(source);
                    IInterfaceElement opDestIE = opDestination.getInterface().getInterfaceElement(dest);
                    if (opSourceIE != null && opDestIE != null) {
                        return ConnectionsHelper.findConnection(opSourceIE, opDestIE);
                    }
                }
            }
        }
        return null;
    }

    private static Connection findConnection(IInterfaceElement source, IInterfaceElement destination) {
        for (Connection con : source.getOutputConnections()) {
            if (con.getDestination() != destination) continue;
            return con;
        }
        return null;
    }

    private ConnectionsHelper() {
        throw new UnsupportedOperationException("Helper class ConnectionsHelper should not be instantiated!");
    }
}

