/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.internal.StyleUtil;
import org.eclipse.lsp4e.operations.completion.CompletionProposalTools;
import org.eclipse.lsp4e.operations.completion.CompletionSnippetParser;
import org.eclipse.lsp4e.operations.hover.FocusableBrowserInformationControl;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
ICompletionProposalExtension7,
IContextInformation {
    private static final int RESOLVE_TIMEOUT = 500;
    private static final String TM_SELECTED_TEXT = "TM_SELECTED_TEXT";
    private static final String TM_CURRENT_LINE = "TM_CURRENT_LINE";
    private static final String TM_CURRENT_WORD = "TM_CURRENT_WORD";
    private static final String TM_LINE_INDEX = "TM_LINE_INDEX";
    private static final String TM_LINE_NUMBER = "TM_LINE_NUMBER";
    private static final String TM_FILENAME = "TM_FILENAME";
    private static final String TM_FILENAME_BASE = "TM_FILENAME_BASE";
    private static final String TM_DIRECTORY = "TM_DIRECTORY";
    private static final String TM_FILEPATH = "TM_FILEPATH";
    protected final CompletionItem item;
    private final int initialOffset;
    protected int bestOffset = -1;
    protected int currentOffset = -1;
    protected @Nullable ITextViewer viewer;
    private final IDocument document;
    private final boolean isIncomplete;
    private @Nullable IRegion selection;
    private @Nullable LinkedPosition firstPosition;
    private @Nullable Integer rankCategory;
    private @Nullable Integer rankScore;
    private @Nullable String documentFilter;
    private String documentFilterAddition = "";
    private final LanguageServerWrapper languageServerWrapper;

    public LSCompletionProposal(IDocument document, int offset, CompletionItem item, LanguageServerWrapper languageServerWrapper) {
        this(document, offset, item, null, languageServerWrapper, false);
    }

    public LSCompletionProposal(IDocument document, int offset, CompletionItem item, @Nullable CompletionItemDefaults defaults, LanguageServerWrapper languageServerWrapper, boolean isIncomplete) {
        this.item = item;
        this.document = document;
        this.languageServerWrapper = languageServerWrapper;
        this.initialOffset = offset;
        this.currentOffset = offset;
        this.bestOffset = this.getPrefixCompletionStart(document, offset);
        this.isIncomplete = isIncomplete;
        if (defaults != null) {
            String textEditText;
            if (item.getInsertTextFormat() == null) {
                item.setInsertTextFormat(defaults.getInsertTextFormat());
            }
            if (item.getCommitCharacters() == null) {
                item.setCommitCharacters(defaults.getCommitCharacters());
            }
            if (item.getInsertTextMode() == null) {
                item.setInsertTextMode(defaults.getInsertTextMode());
            }
            if ((textEditText = item.getTextEditText()) != null && defaults.getEditRange() != null) {
                item.setTextEdit((Either)defaults.getEditRange().map(range -> Either.forLeft((Object)new TextEdit(range, textEditText)), insertReplaceRange -> Either.forRight((Object)new InsertReplaceEdit(textEditText, insertReplaceRange.getInsert(), insertReplaceRange.getReplace()))));
            }
        }
    }

    public String getDocumentFilter(int offset) throws BadLocationException {
        if (this.documentFilter != null) {
            if (offset != this.currentOffset) {
                this.currentOffset = offset;
                this.rankScore = null;
                this.rankCategory = null;
                this.documentFilterAddition = offset > this.initialOffset ? this.document.get(this.initialOffset, offset - this.initialOffset) : "";
            }
            return this.documentFilter + this.documentFilterAddition;
        }
        this.currentOffset = offset;
        return this.getDocumentFilter();
    }

    public String getDocumentFilter() throws BadLocationException {
        if (this.documentFilter != null) {
            return this.documentFilter + this.documentFilterAddition;
        }
        String documentFilter = this.documentFilter = CompletionProposalTools.getFilterFromDocument(this.document, this.currentOffset, this.getFilterString(), this.bestOffset);
        this.documentFilterAddition = "";
        return documentFilter;
    }

    public int getRankScore() {
        int rankScore;
        if (this.rankScore != null) {
            return this.rankScore;
        }
        try {
            rankScore = CompletionProposalTools.getScoreOfFilterMatch(this.getDocumentFilter(), this.getFilterString());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            rankScore = -1;
        }
        this.rankScore = rankScore;
        return rankScore;
    }

    public int getRankCategory() {
        int rankCategory;
        if (this.rankCategory != null) {
            return this.rankCategory;
        }
        try {
            rankCategory = CompletionProposalTools.getCategoryOfFilterMatch(this.getDocumentFilter(), this.getFilterString());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            rankCategory = 5;
        }
        this.rankCategory = rankCategory;
        return rankCategory;
    }

    public int getBestOffset() {
        return this.bestOffset;
    }

    public void updateOffset(int offset) {
        this.bestOffset = this.getPrefixCompletionStart(this.document, offset);
    }

    public CompletionItem getItem() {
        return this.item;
    }

    private boolean isDeprecated() {
        return this.item.getDeprecated() != null && this.item.getDeprecated() != false;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, final BoldStylerProvider boldStylerProvider) {
        StyledString res;
        String rawString = this.getDisplayString();
        StyledString styledString = res = this.isDeprecated() ? new StyledString(rawString, StyleUtil.DEPRECATE) : new StyledString(rawString);
        if (offset > this.bestOffset) {
            try {
                String subString = this.getDocumentFilter(offset).toLowerCase();
                int lastIndex = 0;
                String lowerRawString = rawString.toLowerCase();
                char[] cArray = subString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Character c = Character.valueOf(cArray[n2]);
                    int index = lowerRawString.indexOf(c.charValue(), lastIndex);
                    if (index < 0) {
                        return res;
                    }
                    res.setStyle(index, 1, new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            if (LSCompletionProposal.this.isDeprecated()) {
                                StyleUtil.DEPRECATE.applyStyles(textStyle);
                            }
                            boldStylerProvider.getBoldStyler().applyStyles(textStyle);
                        }
                    });
                    lastIndex = index + 1;
                    ++n2;
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return res;
    }

    public String getDisplayString() {
        return this.item.getLabel();
    }

    public StyledString getStyledDisplayString() {
        if (Boolean.TRUE.equals(this.item.getDeprecated())) {
            return new StyledString(this.getDisplayString(), StyleUtil.DEPRECATE);
        }
        return new StyledString(this.getDisplayString());
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public @Nullable IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }

    public String getAdditionalProposalInfo(IProgressMonitor monitor) {
        String htmlDocString;
        if (this.languageServerWrapper.isActive() && this.resolvesCompletionItem(this.languageServerWrapper.getServerCapabilities())) {
            this.resolveItem();
        }
        StringBuilder res = new StringBuilder();
        if (this.item.getDetail() != null && !this.item.getDetail().isEmpty()) {
            res.append("<p>" + this.item.getDetail() + "</p>");
        }
        if (res.length() > 0) {
            res.append("<br/>");
        }
        if (this.item.getDocumentation() != null && (htmlDocString = LSPEclipseUtils.getHtmlDocString((Either<String, MarkupContent>)this.item.getDocumentation())) != null) {
            res.append(htmlDocString);
        }
        return res.toString();
    }

    private boolean resolvesCompletionItem(@Nullable ServerCapabilities capabilities) {
        CompletionOptions completionProvider;
        if (capabilities != null && (completionProvider = capabilities.getCompletionProvider()) != null) {
            Boolean hasResolveProvider = completionProvider.getResolveProvider();
            return hasResolveProvider != null && hasResolveProvider != false;
        }
        return false;
    }

    private void resolveItem() {
        try {
            this.languageServerWrapper.execute(ls -> ls.getTextDocumentService().resolveCompletionItem(this.item).thenAccept(this::updateCompletionItem)).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not resolve completion items due to timeout after 500 milliseconds in `completionItem/resolve`", e);
        }
    }

    private void updateCompletionItem(@Nullable CompletionItem resolvedItem) {
        if (resolvedItem == null) {
            return;
        }
        if (resolvedItem.getLabel() != null) {
            this.item.setLabel(resolvedItem.getLabel());
        }
        if (resolvedItem.getKind() != null) {
            this.item.setKind(resolvedItem.getKind());
        }
        if (resolvedItem.getDetail() != null) {
            this.item.setDetail(resolvedItem.getDetail());
        }
        if (resolvedItem.getDocumentation() != null) {
            this.item.setDocumentation(resolvedItem.getDocumentation());
        }
        if (resolvedItem.getInsertText() != null) {
            this.item.setInsertText(resolvedItem.getInsertText());
        }
        if (resolvedItem.getInsertTextFormat() != null) {
            this.item.setInsertTextFormat(resolvedItem.getInsertTextFormat());
        }
        if (resolvedItem.getTextEdit() != null) {
            this.item.setTextEdit(resolvedItem.getTextEdit());
        }
        if (resolvedItem.getAdditionalTextEdits() != null) {
            this.item.setAdditionalTextEdits(resolvedItem.getAdditionalTextEdits());
        }
    }

    public @Nullable CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.item.getInsertText().substring(completionOffset - this.bestOffset);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        Either textEdit = this.item.getTextEdit();
        if (textEdit != null) {
            try {
                return LSPEclipseUtils.toOffset(this.getTextEditRange().getStart(), document);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        String insertText = this.getInsertText();
        try {
            String subDoc = document.get(Math.max(0, completionOffset - insertText.length()), Math.min(insertText.length(), completionOffset));
            int i = 0;
            while (i < insertText.length() && i < completionOffset) {
                String tentativeCommonString = subDoc.substring(i);
                if (insertText.startsWith(tentativeCommonString)) {
                    return completionOffset - tentativeCommonString.length();
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return completionOffset;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void apply(IDocument document, char trigger, int stateMask, int offset) {
        insertText = null;
        eitherTextEdit = this.item.getTextEdit();
        textEdit = null;
        if (eitherTextEdit != null) {
            if (eitherTextEdit.isLeft()) {
                textEdit = (TextEdit)eitherTextEdit.getLeft();
            } else {
                insertReplaceEdit = (InsertReplaceEdit)eitherTextEdit.getRight();
                textEdit = new TextEdit(insertReplaceEdit.getInsert(), insertReplaceEdit.getNewText());
            }
        }
        try {
            if (textEdit == null) {
                insertText = this.getInsertText();
                start = LSPEclipseUtils.toPosition(this.bestOffset, document);
                end = LSPEclipseUtils.toPosition(offset, document);
                textEdit = new TextEdit(new Range(start, end), insertText);
            } else if (offset > this.initialOffset) {
                shift = offset - this.initialOffset;
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + shift);
            }
            start = textEdit.getRange().getStart();
            end = textEdit.getRange().getEnd();
            if (start.getLine() > end.getLine() || start.getLine() == end.getLine() && start.getCharacter() > end.getCharacter()) {
                textEdit.getRange().setEnd(start);
                textEdit.getRange().setStart(end);
            }
            documentEnd = LSPEclipseUtils.toPosition(document.getLength(), document);
            textEditEnd = textEdit.getRange().getEnd();
            if (documentEnd.getLine() < textEditEnd.getLine() || documentEnd.getLine() == textEditEnd.getLine() && documentEnd.getCharacter() < textEditEnd.getCharacter()) {
                textEdit.getRange().setEnd(documentEnd);
            }
            if (insertText != null) {
                shift = offset - this.bestOffset;
                commonSize = 0;
                while (commonSize < insertText.length() - shift && document.getLength() > offset + commonSize && document.getChar(this.bestOffset + shift + commonSize) == insertText.charAt(commonSize + shift)) {
                    ++commonSize;
                }
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + commonSize);
            }
            insertText = textEdit.getNewText();
            regions = Collections.emptyMap();
            insertionOffset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
            if (this.item.getInsertTextMode() == InsertTextMode.AdjustIndentation) {
                insertText = this.adjustIndentation(document, insertText, insertionOffset);
            }
            insertionOffset = this.computeNewOffset(this.item.getAdditionalTextEdits(), insertionOffset, document);
            if (this.item.getInsertTextFormat() == InsertTextFormat.Snippet) {
                completionSnippetParser = new CompletionSnippetParser(document, insertText, insertionOffset, (Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getVariableValue(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((LSCompletionProposal)this));
                insertText = completionSnippetParser.parse();
                regions = completionSnippetParser.getLinkedPositions();
                if (!regions.isEmpty() && this.firstPosition == null) {
                    this.firstPosition = (LinkedPosition)((List)regions.values().iterator().next()).get(0);
                }
            }
            textEdit.setNewText(insertText);
            additionalEdits = this.item.getAdditionalTextEdits();
            if (additionalEdits != null && !additionalEdits.isEmpty()) {
                initialPosition = LSPEclipseUtils.toPosition(this.initialOffset, document);
                allEdits = new ArrayList<TextEdit>();
                allEdits.add(textEdit);
                additionalEdits.stream().forEach((Consumer<TextEdit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$5(int org.eclipse.jface.text.IDocument org.eclipse.lsp4j.Position java.util.ArrayList org.eclipse.lsp4j.TextEdit ), (Lorg/eclipse/lsp4j/TextEdit;)V)((LSCompletionProposal)this, (int)offset, (IDocument)document, (Position)initialPosition, allEdits));
                LSPEclipseUtils.applyEdits(document, allEdits);
            } else {
                LSPEclipseUtils.applyEdit(textEdit, document);
            }
            if (regions.size() != 1 || ((List)regions.values().iterator().next()).size() != 1) ** GOTO lbl-1000
            if (((List)regions.values().iterator().next()).stream().noneMatch((Predicate<LinkedPosition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/eclipse/jface/text/link/LinkedPosition;)Z)(ProposalPosition.class))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            onlyPlaceCaret = v0;
            viewer = this.viewer;
            if (viewer != null && !regions.isEmpty() && !onlyPlaceCaret) {
                model = new LinkedModeModel();
                for (List positions : regions.values()) {
                    group = new LinkedPositionGroup();
                    for (LinkedPosition position : positions) {
                        group.addPosition(position);
                    }
                    model.addGroup(group);
                }
                model.forceInstall();
                ui = new EditorLinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            } else if (onlyPlaceCaret) {
                region = (org.eclipse.jface.text.Position)((List)regions.values().iterator().next()).get(0);
                this.selection = new Region(region.getOffset(), region.getLength());
            } else {
                this.selection = new Region(insertionOffset + textEdit.getNewText().length(), 0);
            }
            if (this.item.getCommand() != null) {
                command = this.item.getCommand();
                serverCapabilities = this.languageServerWrapper.getServerCapabilities();
                v1 = provider = serverCapabilities == null ? null : serverCapabilities.getExecuteCommandProvider();
                if (provider != null && provider.getCommands().contains(command.getCommand())) {
                    this.languageServerWrapper.execute((Function<LanguageServer, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(org.eclipse.lsp4j.Command org.eclipse.lsp4j.services.LanguageServer ), (Lorg/eclipse/lsp4j/services/LanguageServer;)Ljava/util/concurrent/CompletableFuture;)((Command)command));
                } else {
                    CommandExecutor.executeCommandClientSide(command, document);
                }
            }
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private String adjustIndentation(IDocument document, String insertText, int insertionOffset) throws BadLocationException {
        int line = document.getLineOfOffset(insertionOffset);
        int whitespaceOffset = document.getLineOffset(line);
        StringBuilder whitespacesBeforeInsertion = new StringBuilder();
        whitespacesBeforeInsertion.append('\n');
        while (whitespaceOffset < insertionOffset && Character.isWhitespace(document.getChar(whitespaceOffset))) {
            whitespacesBeforeInsertion.append(document.getChar(whitespaceOffset));
            ++whitespaceOffset;
        }
        return insertText.replace("\n", whitespacesBeforeInsertion);
    }

    private int computeNewOffset(@Nullable List<TextEdit> additionalTextEdits, int insertionOffset, IDocument doc) {
        if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
            int adjustment = 0;
            for (TextEdit edit : additionalTextEdits) {
                try {
                    Range rng = edit.getRange();
                    int start = LSPEclipseUtils.toOffset(rng.getStart(), doc);
                    if (start > insertionOffset) continue;
                    int end = LSPEclipseUtils.toOffset(rng.getEnd(), doc);
                    int orgLen = end - start;
                    int newLeng = edit.getNewText().length();
                    int editChange = newLeng - orgLen;
                    adjustment += editChange;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
            return insertionOffset + adjustment;
        }
        return insertionOffset;
    }

    private String getVariableValue(String variableName) {
        return switch (variableName) {
            case TM_FILENAME_BASE -> {
                IPath path = LSPEclipseUtils.toPath(this.document);
                String fileName = path == null ? null : path.removeFileExtension().lastSegment();
                String  secretYieldValue = fileName != null ? fileName : "";
                yield  secretYieldValue;
            }
            case TM_FILENAME -> {
                IPath path = LSPEclipseUtils.toPath(this.document);
                String fileName = path == null ? null : path.lastSegment();
                String  secretYieldValue = fileName != null ? fileName : "";
                yield  secretYieldValue;
            }
            case TM_FILEPATH -> {
                IPath path = LSPEclipseUtils.toPath(this.document);
                String  secretYieldValue = path == null ? "" : this.getAbsoluteLocation(path);
                yield  secretYieldValue;
            }
            case TM_DIRECTORY -> {
                IPath path = LSPEclipseUtils.toPath(this.document);
                String  secretYieldValue = path == null ? "" : this.getAbsoluteLocation(path.removeLastSegments(1));
                yield  secretYieldValue;
            }
            case TM_LINE_INDEX -> {
                try {
                    String  secretYieldValue = Integer.toString(this.getTextEditRange().getStart().getLine());
                    yield  secretYieldValue;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    String  secretYieldValue = "";
                    yield  secretYieldValue;
                }
            }
            case TM_LINE_NUMBER -> {
                try {
                    String  secretYieldValue = Integer.toString(this.getTextEditRange().getStart().getLine() + 1);
                    yield  secretYieldValue;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    String  secretYieldValue = "";
                    yield  secretYieldValue;
                }
            }
            case TM_CURRENT_LINE -> {
                try {
                    String line;
                    int currentLineIndex = this.getTextEditRange().getStart().getLine();
                    IRegion lineInformation = this.document.getLineInformation(currentLineIndex);
                    String  secretYieldValue = line = this.document.get(lineInformation.getOffset(), lineInformation.getLength());
                    yield  secretYieldValue;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    String  secretYieldValue = "";
                    yield  secretYieldValue;
                }
            }
            case TM_SELECTED_TEXT -> {
                try {
                    String selectedText;
                    ITextViewer viewer = NullSafetyHelper.castNonNull(this.viewer);
                    String  secretYieldValue = selectedText = this.document.get(viewer.getSelectedRange().x, viewer.getSelectedRange().y);
                    yield  secretYieldValue;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    String  secretYieldValue = "";
                    yield  secretYieldValue;
                }
            }
            case TM_CURRENT_WORD -> {
                try {
                    Object  secretYieldValue;
                    ITextViewer viewer = NullSafetyHelper.castNonNull(this.viewer);
                    Object selectedText = this.document.get(viewer.getSelectedRange().x, viewer.getSelectedRange().y);
                    int beforeSelection = viewer.getSelectedRange().x - 1;
                    while (beforeSelection >= 0 && Character.isUnicodeIdentifierPart(this.document.getChar(beforeSelection))) {
                        selectedText = beforeSelection + (String)selectedText;
                        --beforeSelection;
                    }
                    int afterSelection = viewer.getSelectedRange().x + viewer.getSelectedRange().y;
                    while (afterSelection < this.document.getLength() && Character.isUnicodeIdentifierPart(afterSelection)) {
                        selectedText = (String)selectedText + this.document.getChar(afterSelection);
                        ++afterSelection;
                    }
                    yield  secretYieldValue = selectedText;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    String  secretYieldValue = "";
                    yield  secretYieldValue;
                }
            }
            default -> {
                void var3_34;
                String  secretYieldValue = variableName;
                yield var3_34;
            }
        };
    }

    private Range getTextEditRange() throws BadLocationException {
        Either textEdit = this.item.getTextEdit();
        if (textEdit != null) {
            return (Range)textEdit.map(TextEdit::getRange, InsertReplaceEdit::getInsert);
        }
        Position start = LSPEclipseUtils.toPosition(this.bestOffset, this.document);
        Position end = LSPEclipseUtils.toPosition(this.initialOffset, this.document);
        return new Range(start, end);
    }

    private String getAbsoluteLocation(IPath path) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            IPath location;
            IPath iPath = location = res.getType() == 4 ? res.getLocation() : res.getRawLocation();
            if (location != null) {
                return location.toOSString();
            }
        }
        return path.toFile().getAbsolutePath();
    }

    protected String getInsertText() {
        String insertText = this.item.getInsertText();
        Either eitherTextEdit = this.item.getTextEdit();
        if (eitherTextEdit != null) {
            insertText = (String)eitherTextEdit.map(TextEdit::getNewText, InsertReplaceEdit::getNewText);
        }
        if (insertText == null) {
            insertText = this.item.getLabel();
        }
        return insertText;
    }

    public @Nullable Point getSelection(IDocument document) {
        LinkedPosition firstPosition = this.firstPosition;
        if (firstPosition != null) {
            return new Point(firstPosition.getOffset(), firstPosition.getLength());
        }
        IRegion selection = this.selection;
        if (selection == null) {
            return null;
        }
        return new Point(selection.getOffset(), selection.getLength());
    }

    public @Nullable String getAdditionalProposalInfo() {
        return this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
    }

    public @Nullable Image getImage() {
        return LSPImages.imageFromCompletionItem(this.item);
    }

    public @Nullable IContextInformation getContextInformation() {
        return this;
    }

    public String getContextDisplayString() {
        return Objects.toString(this.getAdditionalProposalInfo());
    }

    public String getInformationDisplayString() {
        return Objects.toString(this.getAdditionalProposalInfo());
    }

    public String getSortText() {
        if (this.item.getSortText() != null && !this.item.getSortText().isEmpty()) {
            return this.item.getSortText();
        }
        return this.item.getLabel();
    }

    public String getFilterString() {
        if (this.item.getFilterText() != null && !this.item.getFilterText().isEmpty()) {
            return this.item.getFilterText();
        }
        return this.item.getLabel();
    }

    public boolean isValidFor(IDocument document, int offset) {
        return (!this.isIncomplete || offset == this.initialOffset) && this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        this.viewer = viewer;
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        if (this.item.getLabel() == null || this.item.getLabel().isEmpty()) {
            return false;
        }
        if (offset < this.bestOffset) {
            return false;
        }
        try {
            String documentFilter = this.getDocumentFilter(offset);
            if (!documentFilter.isEmpty()) {
                return (!this.isIncomplete || this.currentOffset == this.initialOffset) && CompletionProposalTools.isSubstringFoundOrderedInString(documentFilter, this.getFilterString());
            }
            if (this.item.getTextEdit() != null) {
                return offset == LSPEclipseUtils.toOffset(this.getTextEditRange().getStart(), document);
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.viewer = viewer;
        IDocument doc = viewer.getDocument();
        if (doc != null) {
            this.apply(doc, trigger, stateMask, offset);
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.apply(document, trigger, 0, offset);
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    public char @Nullable [] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 131072;
    }

    private /* synthetic */ void lambda$5(int n, IDocument iDocument, Position position, ArrayList arrayList, TextEdit te) {
        int shift = n - this.initialOffset;
        if (shift != 0) {
            try {
                int start = LSPEclipseUtils.toOffset(te.getRange().getStart(), iDocument);
                int end = LSPEclipseUtils.toOffset(te.getRange().getEnd(), iDocument);
                if (start > this.initialOffset && te.getRange().getStart().getLine() == position.getLine()) {
                    te.getRange().setStart(LSPEclipseUtils.toPosition(start + shift, iDocument));
                    te.getRange().setEnd(LSPEclipseUtils.toPosition(end + shift, iDocument));
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        arrayList.add(te);
    }

    private static /* synthetic */ CompletableFuture lambda$7(Command command, LanguageServer ls) {
        return ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments()));
    }
}

