/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.Iterator;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Continuous;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DContinuous;
import org.ascape.model.space.Location;

public class Continuous1D
extends CollectionSpace
implements Continuous {
    private static final long serialVersionUID = 1L;
    private int size;

    public Continuous1D() {
        this(new Coordinate1DContinuous(0.0));
    }

    public Continuous1D(Coordinate1DContinuous extent) {
        this.setExtent(extent);
    }

    public void coordinateSweep() {
    }

    public void populate() {
        super.populate();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Location)iter.next()).setCoordinate(new Coordinate1DContinuous(0.0));
        }
    }

    public double calculateDistance(Coordinate origin, Coordinate target) {
        if (this.geometry.isPeriodic()) {
            throw new RuntimeException("Periodic continuous geometry not yet implemented for this space.");
        }
        return super.calculateDistance(origin, target);
    }

    public double distancePerIteration(double velocity) {
        return velocity;
    }

    public Coordinate findRandomCoordinate() {
        double max = ((Coordinate1DContinuous)this.extent).getXValue();
        return new Coordinate1DContinuous(this.randomInRange(0.0, max));
    }

    public void moveToward(Location origin, Coordinate target, double distance) {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    public void normalize(Coordinate coor) {
        if (this.geometry.isPeriodic()) {
            if (((Coordinate1DContinuous)coor).getXValue() < 0.0) {
                ((Coordinate1DContinuous)coor).setXValue(((Coordinate1DContinuous)coor).getXValue() + ((Coordinate1DContinuous)this.getExtent()).getXValue());
            } else if (((Coordinate1DContinuous)coor).getXValue() > ((Coordinate1DContinuous)this.getExtent()).getXValue()) {
                ((Coordinate1DContinuous)coor).setXValue(((Coordinate1DContinuous)coor).getXValue() - ((Coordinate1DContinuous)this.getExtent()).getXValue());
            }
        } else if (((Coordinate1DContinuous)coor).getXValue() < 0.0) {
            ((Coordinate1DContinuous)coor).setXValue(0.0);
        } else if (((Coordinate1DContinuous)coor).getXValue() > ((Coordinate1DContinuous)this.getExtent()).getXValue()) {
            ((Coordinate1DContinuous)coor).setXValue(((Coordinate1DContinuous)this.getExtent()).getXValue());
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

