/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.adapt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ascape.model.Agent;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.Scape;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.Continuous2D;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Graph;
import org.ascape.model.space.Node;
import org.ascape.model.space.Singleton;
import org.ascape.model.space.Space;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.space.ILocation;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.amp.escape.ascape.adapt.AscapeGEFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AscapeModelProvider
implements ILocationProvider,
IGraphProvider,
ICompositionProvider {
    private static AscapeModelProvider singleton;

    public ILocation getLocation(Object located) {
        LocatedAgent agent = (LocatedAgent)located;
        Coordinate coor = null;
        coor = agent instanceof CellOccupant && ((CellOccupant)agent).getHostCell() != null ? ((CellOccupant)agent).getHostCell().getCoordinate() : agent.getCoordinate();
        ILocation adaptCoordinate = AscapeGEFUtils.adaptCoordinate(coor);
        if (adaptCoordinate instanceof ILocation2D) {
            return adaptCoordinate;
        }
        return null;
    }

    public ILocation getExtent(Object located) {
        Space spatialScape = this.getSpatialScape((Scape)located);
        if (spatialScape != null) {
            return AscapeGEFUtils.adaptCoordinate(spatialScape.getExtent());
        }
        return null;
    }

    public Space getSpatialScape(Scape scape) {
        if (scape.getSpace() instanceof Array2D) {
            return scape.getSpace();
        }
        if (scape.getSpace() instanceof Continuous2D) {
            return scape.getSpace();
        }
        if (scape.getPrototypeAgent() instanceof Scape) {
            for (Object subScape : scape) {
                Space spatialScape = this.getSpatialScape((Scape)subScape);
                if (spatialScape == null) continue;
                return spatialScape;
            }
        }
        return null;
    }

    public Map<Object, Object> getAdjacencyMap(Object scape) {
        return ((Graph)((Scape)scape).getSpace()).getAdjacencyMap();
    }

    public List<Object> getNeighborsFor(Object scape, Object source) {
        return ((Graph)((Scape)scape).getSpace()).getNeighborsFor((Node)source);
    }

    public boolean isGraph(Object graph) {
        return graph instanceof Graph || graph instanceof Scape && ((Scape)graph).getSpace() instanceof Graph;
    }

    public Iterable<Object> getIteratable(Object object) {
        return this.getList(object);
    }

    public List<Object> getList(Object parent) {
        Scape scape = (Scape)parent;
        if (scape.isRoot()) {
            ArrayList<Object> use = new ArrayList<Object>((Collection<Object>)scape);
            ArrayList hosts = new ArrayList();
            ArrayList graphs = new ArrayList();
            for (Object agent : scape) {
                if (((Scape)agent).getPrototypeAgent() instanceof HostCell) {
                    hosts.add(agent);
                }
                if (((Scape)agent).getSpace() instanceof Graph) {
                    graphs.add(agent);
                }
                if (((Scape)agent).getSpace() instanceof Continuous2D) {
                    graphs.add(agent);
                }
                if (!(((Scape)agent).getSpace() instanceof Singleton)) continue;
                use.remove(agent);
            }
            use.removeAll(hosts);
            use.addAll(0, hosts);
            use.removeAll(graphs);
            use.addAll(graphs.size(), graphs);
            return use;
        }
        if (scape.getSpace() instanceof List) {
            return (List)scape.getSpace();
        }
        return new ArrayList<Object>((Collection<Object>)scape);
    }

    public boolean isMutable(Object parent) {
        Scape scape = (Scape)parent;
        return scape.isMutable() || scape.getPeriod() < 1 && !scape.isRoot();
    }

    public Object getParent(Object member) {
        return ((Agent)member).getScape();
    }

    public boolean isChildrenComposition(Object parent) {
        return parent instanceof Scape && ((Scape)parent).getPrototypeAgent() instanceof Scape;
    }

    public Class<?> getChildrenClass(Object member) {
        Object childrenPrototype = this.getChildrenPrototype(member);
        if (childrenPrototype == null) {
            return Agent.class;
        }
        return childrenPrototype.getClass();
    }

    public Object getChildrenPrototype(Object member) {
        Agent prototypeAgent;
        if (member instanceof Scape && (prototypeAgent = ((Scape)member).getPrototypeAgent()) != null) {
            return prototypeAgent;
        }
        return null;
    }

    public static AscapeModelProvider getDefault() {
        if (singleton == null) {
            singleton = new AscapeModelProvider();
        }
        return singleton;
    }

    public boolean isComposition(Object member) {
        return member instanceof Scape;
    }
}

