/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.viewer;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw3d.Draw3DCanvas;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.LightweightSystem3D;
import org.eclipse.draw3d.XYZLayout;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.draw3d.graphics3d.Graphics3DType;
import org.eclipse.draw3d.ui.camera.CameraInputHandler;
import org.eclipse.draw3d.ui.export.Export3DAction;
import org.eclipse.draw3d.ui.export.Export3DFigureProvider;
import org.eclipse.draw3d.ui.preferences.CameraPreferenceDistributor;
import org.eclipse.draw3d.ui.preferences.ScenePreferenceDistributor;
import org.eclipse.draw3d.ui.viewer.CameraInputListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Draw3DViewer
extends EditorPart {
    protected CameraPreferenceDistributor m_cameraPreferenceDistributor;
    protected Draw3DCanvas m_canvas;
    protected Collection<Export3DAction> m_export3DActions = new HashSet<Export3DAction>();
    private CameraInputListener m_inputListener;
    protected LightweightSystem3D m_lightweightSystem;
    protected ScenePreferenceDistributor m_scenePreferenceDistributor;

    protected abstract IFigure3D createContents();

    public void createPartControl(Composite i_parent) {
        Composite c = new Composite(i_parent, 0);
        c.setLayout((Layout)new FillLayout());
        this.m_lightweightSystem = new LightweightSystem3D();
        this.m_lightweightSystem.setDrawAxes(true);
        this.m_canvas = Draw3DCanvas.createCanvas((Composite)c, (int)0, (LightweightSystem3D)this.m_lightweightSystem);
        this.m_lightweightSystem.setControl((Canvas)this.m_canvas);
        this.m_lightweightSystem.getRootFigure().setLayoutManager((LayoutManager)new XYZLayout());
        IFigure3D figure = this.createContents();
        this.m_lightweightSystem.setContents((IFigure)figure);
        this.m_canvas.addDisposeListener((DisposeListener)this.m_lightweightSystem);
        this.m_scenePreferenceDistributor = new ScenePreferenceDistributor((IScene)this.m_lightweightSystem);
        CameraInputHandler handler = new CameraInputHandler();
        handler.setScene((IScene)this.m_lightweightSystem);
        this.m_cameraPreferenceDistributor = new CameraPreferenceDistributor(handler);
        this.m_scenePreferenceDistributor.start();
        this.m_cameraPreferenceDistributor.start();
        this.m_inputListener = new CameraInputListener(handler);
        this.m_canvas.addKeyListener((KeyListener)this.m_inputListener);
        this.m_canvas.addMouseListener((MouseListener)this.m_inputListener);
        this.m_canvas.addMouseMoveListener((MouseMoveListener)this.m_inputListener);
        this.m_canvas.addMouseWheelListener((MouseWheelListener)this.m_inputListener);
        this.m_canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent i_e) {
                if (Draw3DViewer.this.m_inputListener != null) {
                    Draw3DViewer.this.m_canvas.removeKeyListener((KeyListener)Draw3DViewer.this.m_inputListener);
                    Draw3DViewer.this.m_canvas.removeMouseListener((MouseListener)Draw3DViewer.this.m_inputListener);
                    Draw3DViewer.this.m_canvas.removeMouseMoveListener((MouseMoveListener)Draw3DViewer.this.m_inputListener);
                    Draw3DViewer.this.m_canvas.removeMouseWheelListener((MouseWheelListener)Draw3DViewer.this.m_inputListener);
                    Draw3DViewer.this.m_inputListener = null;
                }
            }
        });
        Export3DFigureProvider figureProvider = new Export3DFigureProvider(){

            public IFigure3D getFigure() {
                return (IFigure3D)Draw3DViewer.this.m_lightweightSystem.getRootFigure();
            }
        };
        for (Graphics3DDescriptor descr : Graphics3DRegistry.getRenderersForType((Graphics3DType)Graphics3DType.EXPORT)) {
            String id = descr.getRendererID();
            Export3DAction action = new Export3DAction(id, figureProvider);
            this.m_export3DActions.add(action);
        }
    }

    public void dispose() {
        if (this.m_scenePreferenceDistributor != null) {
            this.m_scenePreferenceDistributor.stop();
            this.m_scenePreferenceDistributor = null;
        }
        if (this.m_cameraPreferenceDistributor != null) {
            this.m_cameraPreferenceDistributor.stop();
            this.m_cameraPreferenceDistributor = null;
        }
    }

    public void doSave(IProgressMonitor i_monitor) {
    }

    public void doSaveAs() {
    }

    public Collection<Export3DAction> getExportActions() {
        return this.m_export3DActions;
    }

    public void init(IEditorSite i_site, IEditorInput i_input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)i_site);
        this.setInput(i_input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

