/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.impl;

import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.impl.MinimumDistanceFilterImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;

public class MinimumDistanceFilterCustomImpl
extends MinimumDistanceFilterImpl {
    public WayPointPath process(WayPointPath input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Cannot pass null WayPointPath as input.");
        }
        if (input.getPoints().size() > 2) {
            WayPointPath filtered = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
            if (this.getProgressMonitor() != null) {
                this.getProgressMonitor().beginTask("Filtering WayPointPath.", input.getPoints().size());
            }
            filtered.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates((CartesianPositionCoordinates)input.getPoints().get(0)));
            if (this.getProgressMonitor() != null) {
                this.getProgressMonitor().worked(1);
            }
            CartesianPositionCoordinates previousPoint = (CartesianPositionCoordinates)input.getPoints().get(0);
            int i = 1;
            while (i < input.getPoints().size()) {
                CartesianPositionCoordinates nextPoint = (CartesianPositionCoordinates)input.getPoints().get(i);
                double distance = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)previousPoint, (CartesianPositionCoordinates)nextPoint);
                if (distance > this.getMinimumDistance()) {
                    filtered.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(nextPoint));
                    previousPoint = nextPoint;
                }
                if (this.getProgressMonitor() != null) {
                    this.getProgressMonitor().worked(1);
                }
                ++i;
            }
            if (!input.getEndPoint().equals(filtered.getEndPoint())) {
                filtered.getPoints().add((Object)input.getEndPoint());
            }
            if (this.getProgressMonitor() != null) {
                this.getProgressMonitor().worked(1);
            }
            if (this.getProgressMonitor() != null) {
                this.getProgressMonitor().done();
            }
            return filtered;
        }
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().done();
        }
        return input;
    }
}

