/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.controllers.impl;

import org.eclipse.apogy.addons.geometry.paths.Path;
import org.eclipse.apogy.addons.mobility.MobilePlatform;
import org.eclipse.apogy.addons.mobility.MobilePlatformStatus;
import org.eclipse.apogy.addons.mobility.controllers.PathFollowerState;
import org.eclipse.apogy.addons.mobility.controllers.impl.PathFollowerImpl;
import org.eclipse.apogy.addons.sensors.SensorStatus;
import org.eclipse.apogy.addons.sensors.pose.PoseSensor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFollowerCustomImpl<PlatformType extends MobilePlatform, PathType extends Path>
extends PathFollowerImpl<PlatformType, PathType> {
    private static final Logger Logger = LoggerFactory.getLogger(PathFollowerImpl.class);
    private Adapter platformAdapter = null;
    private Adapter poseSensorAdapter = null;

    @Override
    public void setPath(PathType newPath) {
        if (this.getPathFollowerState() == PathFollowerState.IDLE) {
            super.setPath(newPath);
            this.setDestinationReached(false);
            if (newPath == null) {
                Logger.warn("PathFollowerImpl : Path set to NULL !");
            }
        } else {
            Logger.error("PathFollowerImpl : Cannot set path while in <" + this.getPathFollowerState().getName() + "> state.");
        }
    }

    @Override
    public void setPlatform(PlatformType newPlatform) {
        MobilePlatform oldPlatform = this.platform;
        this.platform = newPlatform;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldPlatform, (Object)this.platform));
        }
        if (oldPlatform != null) {
            oldPlatform.eAdapters().remove((Object)this.getPlateformAdapter());
        }
        if (newPlatform != null) {
            newPlatform.eAdapters().add((Object)this.getPlateformAdapter());
        }
    }

    @Override
    public void setPoseSensor(PoseSensor newPoseSensor) {
        PoseSensor oldPoseSensor = this.poseSensor;
        this.poseSensor = newPoseSensor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldPoseSensor, (Object)this.poseSensor));
        }
        if (oldPoseSensor != null) {
            oldPoseSensor.eAdapters().remove((Object)this.getPoseSensorAdapter());
        }
        if (newPoseSensor != null) {
            newPoseSensor.eAdapters().add((Object)this.getPoseSensorAdapter());
        }
    }

    @Override
    public void setDestinationReached(boolean newDestinationReached) {
        boolean oldDestinationReached = this.destinationReached;
        this.destinationReached = newDestinationReached;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldDestinationReached, this.destinationReached));
        }
        if (newDestinationReached) {
            Logger.info("Destination reached.");
        }
    }

    @Override
    public boolean start() {
        if (this.isTransitionValid(PathFollowerState.RUNNING)) {
            this.setPathFollowerState(PathFollowerState.RUNNING);
            return true;
        }
        Logger.error("Incorrect state <" + this.getPathFollowerState().getName() + "> to pause.");
        return false;
    }

    @Override
    public boolean pause() {
        if (this.isTransitionValid(PathFollowerState.PAUSED)) {
            this.setPathFollowerState(PathFollowerState.PAUSED);
            return true;
        }
        Logger.error("Incorrect state <" + this.getPathFollowerState().getName() + "> to pause.");
        return false;
    }

    @Override
    public boolean resume() {
        if (this.isTransitionValid(PathFollowerState.RUNNING)) {
            this.setPathFollowerState(PathFollowerState.RUNNING);
            return true;
        }
        Logger.error("Incorrect state <" + this.getPathFollowerState().getName() + "> to resume.");
        return false;
    }

    @Override
    public boolean stop() {
        if (this.isTransitionValid(PathFollowerState.IDLE)) {
            this.setPathFollowerState(PathFollowerState.IDLE);
            return true;
        }
        Logger.error("Incorrect state <" + this.getPathFollowerState().getName() + "> to stop.");
        return false;
    }

    @Override
    public boolean isTransitionValid(PathFollowerState state) {
        boolean result = false;
        PathFollowerState currentState = this.getPathFollowerState();
        switch (currentState.getValue()) {
            case 0: {
                switch (state.getValue()) {
                    case -1: 
                    case 1: {
                        result = true;
                    }
                }
                break;
            }
            case 1: {
                switch (state.getValue()) {
                    case -1: 
                    case 0: 
                    case 2: {
                        result = true;
                    }
                }
                break;
            }
            case 2: {
                switch (state.getValue()) {
                    case -1: 
                    case 1: {
                        result = true;
                    }
                }
                break;
            }
            case -1: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private Adapter getPoseSensorAdapter() {
        if (this.poseSensorAdapter == null) {
            this.poseSensorAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(PoseSensor.class) == 6) {
                        if (msg.getNewValue() == SensorStatus.FAILED) {
                            if (PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.PAUSED)) {
                                PathFollowerCustomImpl.this.pause();
                                Logger.warn("Path following pause due to failure of Pose Sensor.");
                            }
                        } else if (msg.getNewValue() == SensorStatus.OFF) {
                            if (PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.PAUSED)) {
                                PathFollowerCustomImpl.this.pause();
                                Logger.warn("Path following pause due to the Pose Sensor being turned OFF.");
                            }
                        } else if (msg.getNewValue() == SensorStatus.READY && PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.RUNNING)) {
                            PathFollowerCustomImpl.this.resume();
                            Logger.warn("Path following resumed since Pose Sensor is running again.");
                        }
                    }
                }
            };
        }
        return this.poseSensorAdapter;
    }

    private Adapter getPlateformAdapter() {
        if (this.platformAdapter == null) {
            this.platformAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(MobilePlatform.class) == 2) {
                        if (msg.getNewValue() == MobilePlatformStatus.FAILED) {
                            if (PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.PAUSED)) {
                                PathFollowerCustomImpl.this.pause();
                                Logger.warn("Path following pause due to failure of Mobile Plateform.");
                            }
                        } else if (msg.getNewValue() == MobilePlatformStatus.OFF) {
                            if (PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.PAUSED)) {
                                PathFollowerCustomImpl.this.pause();
                                Logger.warn("Path following pause due to Mobile Plateform being turned OFF.");
                            }
                        } else if (msg.getNewValue() == MobilePlatformStatus.READY && PathFollowerCustomImpl.this.isTransitionValid(PathFollowerState.RUNNING)) {
                            PathFollowerCustomImpl.this.resume();
                            Logger.info("Path following resumed since Mobile Plateform is running again.");
                        }
                    }
                }
            };
        }
        return this.platformAdapter;
    }
}

