/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ROSListenerState implements Enumerator
{
    NOT_CONNECTED(0, "NOT_CONNECTED", "Not Connected"),
    CONNECTING(1, "CONNECTING", "Connecting"),
    CONNECTED(2, "CONNECTED", "Connected"),
    STOPPED(3, "STOPPED", "Stopped");

    public static final int NOT_CONNECTED_VALUE = 0;
    public static final int CONNECTING_VALUE = 1;
    public static final int CONNECTED_VALUE = 2;
    public static final int STOPPED_VALUE = 3;
    private static final ROSListenerState[] VALUES_ARRAY;
    public static final List<ROSListenerState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ROSListenerState[]{NOT_CONNECTED, CONNECTING, CONNECTED, STOPPED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ROSListenerState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ROSListenerState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ROSListenerState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ROSListenerState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ROSListenerState get(int value) {
        switch (value) {
            case 0: {
                return NOT_CONNECTED;
            }
            case 1: {
                return CONNECTING;
            }
            case 2: {
                return CONNECTED;
            }
            case 3: {
                return STOPPED;
            }
        }
        return null;
    }

    private ROSListenerState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

