/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.util.Iterator;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFacade;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ApogyROSRegistry;
import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSPublisherManager;
import org.eclipse.apogy.addons.ros.ROSServiceManager;
import org.eclipse.apogy.addons.ros.ROSTopicLauncher;
import org.eclipse.apogy.addons.ros.impl.ROSNodeImpl;
import org.eclipse.apogy.addons.ros.utilities.AsynchronousShutdowner;
import org.eclipse.apogy.addons.ros.utilities.ROSNodeMain;
import org.eclipse.emf.common.util.EList;
import org.ros.node.ConnectedNode;
import org.ros.node.topic.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSNodeCustomImpl
extends ROSNodeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ROSNodeImpl.class);
    private ROSNodeMain rosNodeMain;
    private Thread watchdogThread = null;

    @Override
    public void initialize() throws Exception {
        String rosMasterURI = ApogyAddonsROSFacade.INSTANCE.getROSMasterURI();
        String rosHostName = ApogyAddonsROSFacade.INSTANCE.getROSHostname();
        String rosIP = ApogyAddonsROSFacade.INSTANCE.getROSIp();
        Logger.info("initialize(): ROS_MASTER_URI = <" + rosMasterURI + ">, ROS_HOSTNAME=<" + rosHostName + ">, ROS_IP=<" + rosIP + ">.");
        if (rosMasterURI != null && rosMasterURI.length() > 0) {
            if (rosHostName == null || rosHostName.length() <= 0) {
                Logger.error("ROS_HOSTNAME is undefined.");
                throw new Exception("ROS_HOSTNAME is undefined.");
            }
        } else {
            Logger.error("ROS_MASTER_URI is undefined.");
            throw new Exception("ROS_MASTER_URI is undefined.");
        }
        this.rosNodeMain = new ROSNodeMain(this.getNodeName());
        this.rosNodeMain.addNodeStartedListener(new ROSNodeMain.NodeStartedListener(){

            @Override
            public void nodeStarted(ConnectedNode connectedNode) {
                ROSNodeCustomImpl.this.onStart(connectedNode);
            }
        });
    }

    @Override
    public void start() {
        String message = "is waiting for connection with the ROS Master for the following ROS Interfaces : [";
        Iterator it = this.getModules().iterator();
        while (it.hasNext()) {
            ROSInterface rosInterface = (ROSInterface)it.next();
            message = String.valueOf(message) + rosInterface.getClass().getName();
            message = it.hasNext() ? String.valueOf(message) + ", " : String.valueOf(message) + "]";
        }
        Logger.info("Client <" + this.getNodeName() + "> " + message);
        this.rosNodeMain.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart(ConnectedNode connectedNode) {
        EList<ROSInterface> eList = this.getModules();
        synchronized (eList) {
            this.setConnectedNode(connectedNode);
            if (this.isRestarting()) {
                this.setRestarting(false);
                Logger.info("Resetting topics...");
                this.launchTopics();
                Logger.info("Resetting publishers...");
                this.launchPublishers();
                this.setConnected(true);
            } else {
                for (ROSInterface module : this.getModules()) {
                    this.initializeModule(module);
                }
                this.setConnected(true);
                this.startWatchDog();
            }
        }
        this.setInitialized(true);
    }

    @Override
    public void restart() {
        Logger.info("Restarting....");
        this.shutdown();
        this.setRestarting(true);
        try {
            this.initialize();
            this.start();
        }
        catch (Exception e) {
            Logger.error("restart(): Unable to restart.", (Throwable)e);
        }
    }

    @Override
    public void register(ROSInterface module) {
        this.register(module, true);
    }

    @Override
    public <T> T newFromType(String messageType) {
        return (T)this.getConnectedNode().getTopicMessageFactory().newFromType(messageType);
    }

    @Override
    public void shutdown() {
        Logger.info("Shutting down.");
        this.stopServices();
        this.stopPublishers();
        this.stopTopics();
        AsynchronousShutdowner.add(this.getConnectedNode());
        ApogyROSRegistry.INSTANCE.getRosInterfaceList().removeAll(this.getModules());
    }

    @Override
    public <T> Publisher<T> createPublisher(String topicName, String messageType) {
        return this.getConnectedNode().newPublisher(topicName, messageType);
    }

    @Override
    public ROSServiceManager createServiceManager() {
        ROSServiceManager mgr = ApogyAddonsROSFactory.eINSTANCE.createROSServiceManager();
        mgr.setNode(this);
        this.getServiceManagers().add((Object)mgr);
        return mgr;
    }

    @Override
    public ROSTopicLauncher createTopicLauncher() {
        ROSTopicLauncher launcher = ApogyAddonsROSFactory.eINSTANCE.createROSTopicLauncher();
        launcher.setNode(this);
        this.getTopicLaunchers().add((Object)launcher);
        return launcher;
    }

    @Override
    public ROSPublisherManager createPublisherManager() {
        ROSPublisherManager manager = ApogyAddonsROSFactory.eINSTANCE.createROSPublisherManager();
        manager.setNode(this);
        this.getPublisherManagers().add((Object)manager);
        return manager;
    }

    private void initializeModule(ROSInterface module) {
        String rosMasterURI = ApogyAddonsROSFacade.INSTANCE.getROSMasterURI();
        String rosHostName = ApogyAddonsROSFacade.INSTANCE.getROSHostname();
        String rosIP = ApogyAddonsROSFacade.INSTANCE.getROSIp();
        Logger.info("initializeModule(): ROS_MASTER_URI = <" + rosMasterURI + ">, ROS_HOSTNAME=<" + rosHostName + ">, ROS_IP=<" + rosIP + ">.");
        if (rosMasterURI != null && rosMasterURI.length() > 0) {
            if (rosHostName != null && rosHostName.length() > 0) {
                module.rosInit();
            } else {
                Logger.error("ROS_HOSTNAME is undefined.");
            }
        } else {
            Logger.error("ROS_MASTER_URI is undefined.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ROSInterface module, boolean initialize) {
        EList<ROSInterface> eList = this.getModules();
        synchronized (eList) {
            ROSServiceManager serviceManager = this.createServiceManager();
            ROSPublisherManager publisherManager = this.createPublisherManager();
            ROSTopicLauncher topicLauncher = this.createTopicLauncher();
            ApogyROSRegistry.INSTANCE.getRosInterfaceList().add((Object)module);
            Logger.info("Registering ROS Interface <" + module.getClass().getName() + ">.");
            module.setServiceManager(serviceManager);
            module.setPublisherManager(publisherManager);
            module.setTopicLauncher(topicLauncher);
            this.getModules().add((Object)module);
            module.setNode(this);
            if (this.getConnectedNode() != null && initialize) {
                this.initializeModule(module);
            }
        }
    }

    private void stopServices() {
        Logger.info("Stopping Service Managers.");
        for (ROSServiceManager manager : this.getServiceManagers()) {
            manager.stop();
        }
    }

    private void stopTopics() {
        Logger.info("Stopping Topic Launchers.");
        for (ROSTopicLauncher launcher : this.getTopicLaunchers()) {
            launcher.stop();
        }
    }

    private void launchTopics() {
        Logger.info("Launching Topic Launchers.");
        for (ROSTopicLauncher launcher : this.getTopicLaunchers()) {
            launcher.launch();
        }
    }

    private void stopPublishers() {
        Logger.info("Stopping Publisher Managers.");
        for (ROSPublisherManager manager : this.getPublisherManagers()) {
            manager.stop();
        }
    }

    private void launchPublishers() {
        Logger.info("Launching Publisher Managers.");
        for (ROSPublisherManager manager : this.getPublisherManagers()) {
            manager.launch();
        }
    }

    private void startWatchDog() {
        if (this.watchdogThread == null) {
            this.watchdogThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (this.isAlive()) {
                            if (!ROSNodeCustomImpl.this.isConnected() && !ROSNodeCustomImpl.this.isRestarting() && ROSNodeCustomImpl.this.isInitialized()) {
                                Logger.warn("startWatchDog(): Lost connection to server.");
                                Thread.sleep(5000L);
                                if (ROSNodeCustomImpl.this.isEnableAutoRestartOnConnectionLost()) {
                                    Logger.info("startWatchDog(): Restarting.");
                                    ROSNodeCustomImpl.this.restart();
                                }
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.watchdogThread.start();
        }
    }
}

