/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.ExposureFilter;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.ExposureFilterComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExposureFilterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.ExposureFilterWizardPage";
    private final ExposureFilter exposureFilter;
    private ExposureFilterComposite exposureFilterComposite;
    private DataBindingContext m_bindingContext;

    public ExposureFilterWizardPage(ExposureFilter exposureFilter) {
        super(WIZARD_PAGE_ID);
        this.exposureFilter = exposureFilter;
        this.setTitle("Exposure Filter.");
        this.setDescription("Select filter settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.exposureFilterComposite = new ExposureFilterComposite(top, 0){

            @Override
            protected void newExposureSelected(double exposure) {
                ExposureFilterWizardPage.this.validate();
            }
        };
        this.exposureFilterComposite.setLayoutData(new GridData(4, 4, true, true));
        this.exposureFilterComposite.setExposureFilter(this.exposureFilter);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ExposureFilterWizardPage.this.m_bindingContext != null) {
                    ExposureFilterWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.exposureFilter.getExposure() < 0.0) {
            this.setErrorMessage("Invalid exposure specified ! Must be equal or greater than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

