/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.ApogyAddonsFacade;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.SimpleTool;
import org.eclipse.apogy.addons.SimpleToolList;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleToolListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(SimpleToolListComposite.class);
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;
    private TableViewer viewer;
    private Button btnNew;
    private Button btnDelete;
    private SimpleToolList simpleToolList;
    private Adapter adapter;

    public SimpleToolListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer((Composite)this, 2562);
        Table table = this.viewer.getTable();
        GridData gd_table = new GridData(4, 4, false, true, 1, 2);
        gd_table.minimumWidth = 600;
        gd_table.widthHint = 600;
        table.setLayoutData((Object)gd_table);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleToolListComposite.this.newSimpleToolSelected((SimpleTool)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.viewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof SimpleToolList) {
                    return ((SimpleToolList)object).getSimpleTools().toArray();
                }
                return null;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
                    settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)SimpleToolListComposite.this.getSimpleToolList(), null, (ETypedElement)ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS));
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS, (EObject)SimpleToolListComposite.this.getSimpleToolList(), (EClassSettings)settings, ApogyAddonsPackage.Literals.SIMPLE_TOOL);
                    WizardDialog dialog = new WizardDialog(SimpleToolListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!SimpleToolListComposite.this.viewer.isBusy()) {
                        SimpleToolListComposite.this.viewer.setInput((Object)SimpleToolListComposite.this.getSimpleToolList());
                    }
                }
            }
        });
        Label label = new Label(composite, 258);
        label.setSize(64, 2);
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String toolsToDeleteMessage = "";
                Iterator<SimpleTool> projects = SimpleToolListComposite.this.getSelectedSimpleTools().iterator();
                while (projects.hasNext()) {
                    SimpleTool tool = projects.next();
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + tool.getName();
                    if (!projects.hasNext()) continue;
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected tools", null, "Are you sure to delete these tools: " + toolsToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (SimpleTool tool : SimpleToolListComposite.this.getSelectedSimpleTools()) {
                        try {
                            ApogyAddonsFacade.INSTANCE.deleteTool(tool);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the tool <" + tool.getName() + ">", (Throwable)e);
                        }
                    }
                }
            }
        });
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.setSimpleToolList(ApogyAddonsFacade.INSTANCE.getSimpleToolList());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SimpleToolListComposite.this.m_bindingContext != null) {
                    SimpleToolListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public SimpleToolList getSimpleToolList() {
        return this.simpleToolList;
    }

    public void setSimpleToolList(SimpleToolList simpleToolList) {
        if (this.simpleToolList != null) {
            simpleToolList.eAdapters().remove((Object)this.getAdapter());
        }
        this.simpleToolList = simpleToolList;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (simpleToolList != null) {
            this.m_bindingContext = this.customInitDataBindings();
            simpleToolList.eAdapters().add((Object)this.getAdapter());
            this.viewer.setInput((Object)simpleToolList);
            if (!this.viewer.isBusy()) {
                Table table = this.viewer.getTable();
                int i = 0;
                while (i < table.getColumnCount()) {
                    table.getColumn(i).pack();
                    ++i;
                }
                this.viewer.refresh();
            }
        }
    }

    public List<SimpleTool> getSelectedSimpleTools() {
        return ((IStructuredSelection)this.viewer.getSelection()).toList();
    }

    protected void newSimpleToolSelected(SimpleTool simpleTool) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SimpleToolList) {
                        SimpleToolListComposite.this.setSimpleToolList(SimpleToolListComposite.this.getSimpleToolList());
                    }
                }
            };
        }
        return this.adapter;
    }
}

