/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import org.eclipse.apogy.addons.vehicle.impl.ApogySystemVehiclePoseCorrectorImpl;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystemVehiclePoseCorrectorCustomImpl
extends ApogySystemVehiclePoseCorrectorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystemVehiclePoseCorrectorImpl.class);

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean previousEnabled = this.isEnabled();
        super.setEnabled(newEnabled);
        if (newEnabled && !previousEnabled) {
            try {
                this.updateMeshes();
                if (this.getApogySystemApiAdapter() != null) {
                    Matrix4x4 correctedPose = this.applyCorrection(this.getApogySystemApiAdapter().getPoseTransform());
                    this.getApogySystemApiAdapter().setPoseTransform(correctedPose);
                }
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    @Override
    public Node getSystemRootNode() {
        return this.getApogySystemApiAdapter().getApogySystem().getTopologyRoot().getOriginNode();
    }

    @Override
    public Matrix4x4 applyCorrection(Matrix4x4 originalPose) {
        if (this.isEnabled()) {
            return super.applyCorrection(originalPose);
        }
        return originalPose;
    }
}

