/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExportFileSettingsWizardPage
extends WizardPage {
    private final IFileExporter iFileExporter;
    private Composite container;
    private TableViewer availableExtensionsViewer;
    private TableViewer toExportExtensionsViewer;
    private Text txtDescription;
    private Button addButton;
    private Button removeButton;
    private final List<String> availableExtensions = new ArrayList<String>();
    private final List<String> toExportExtensions = new ArrayList<String>();
    private final List<String> selectedExtensions = new ArrayList<String>();

    public ExportFileSettingsWizardPage(String pageName, IFileExporter iFileExporter, ExportToFileWizard wizard) {
        super(pageName);
        this.setDescription("Select the file extension to use for the export.");
        this.iFileExporter = iFileExporter;
        this.availableExtensions.addAll(iFileExporter.getSupportedFileExtensions());
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.container.setLayout((Layout)layout);
        Label lblAvailableExtensions = new Label(this.container, 0);
        lblAvailableExtensions.setText("Available Extensions");
        lblAvailableExtensions.setAlignment(0x1000000);
        lblAvailableExtensions.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        new Label(this.container, 0);
        Label lblToExportExtensions = new Label(this.container, 0);
        lblToExportExtensions.setText("Extension To Export");
        lblToExportExtensions.setAlignment(0x1000000);
        lblToExportExtensions.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.availableExtensionsViewer = new TableViewer(this.container, 2562);
        Table table = this.availableExtensionsViewer.getTable();
        GridData gd_table = new GridData(16384, 4, false, true, 1, 2);
        gd_table.minimumWidth = 300;
        gd_table.widthHint = 300;
        table.setLayoutData((Object)gd_table);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.availableExtensionsViewer);
        this.availableExtensionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportFileSettingsWizardPage.this.addButton.setEnabled(true);
                ExportFileSettingsWizardPage.this.removeButton.setEnabled(false);
                if (event.getSelection() instanceof IStructuredSelection) {
                    ExportFileSettingsWizardPage.this.selectedExtensions.clear();
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    for (Object item : iStructuredSelection) {
                        if (!(item instanceof String)) continue;
                        String extension = (String)item;
                        ExportFileSettingsWizardPage.this.selectedExtensions.add(extension);
                        String description = ExportFileSettingsWizardPage.this.iFileExporter.getDescription(extension);
                        if (description == null) {
                            description = "No description available.";
                        }
                        ExportFileSettingsWizardPage.this.txtDescription.setText(description);
                    }
                }
            }
        });
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.availableExtensionsViewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setText("Extension");
        trclmnItemName.setWidth(100);
        this.availableExtensionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.availableExtensionsViewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider());
        this.availableExtensionsViewer.setInput(this.availableExtensions);
        this.addButton = new Button(this.container, 8);
        this.addButton.setText("->");
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportFileSettingsWizardPage.this.toExportExtensions.addAll(ExportFileSettingsWizardPage.this.selectedExtensions);
                ExportFileSettingsWizardPage.this.availableExtensions.removeAll(ExportFileSettingsWizardPage.this.selectedExtensions);
                ExportFileSettingsWizardPage.this.selectedExtensions.clear();
                ExportFileSettingsWizardPage.this.availableExtensionsViewer.setInput((Object)ExportFileSettingsWizardPage.this.availableExtensions);
                ExportFileSettingsWizardPage.this.availableExtensionsViewer.refresh();
                ExportFileSettingsWizardPage.this.toExportExtensionsViewer.setInput((Object)ExportFileSettingsWizardPage.this.toExportExtensions);
                ExportFileSettingsWizardPage.this.toExportExtensionsViewer.refresh();
                ExportFileSettingsWizardPage.this.setPageComplete(!ExportFileSettingsWizardPage.this.toExportExtensions.isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.toExportExtensionsViewer = new TableViewer(this.container, 2562);
        Table table1 = this.toExportExtensionsViewer.getTable();
        GridData gd_table1 = new GridData(16384, 4, false, true, 1, 2);
        gd_table1.minimumWidth = 300;
        gd_table1.widthHint = 300;
        table1.setLayoutData((Object)gd_table1);
        table1.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.toExportExtensionsViewer);
        this.toExportExtensionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportFileSettingsWizardPage.this.addButton.setEnabled(false);
                ExportFileSettingsWizardPage.this.removeButton.setEnabled(true);
                if (event.getSelection() instanceof IStructuredSelection) {
                    ExportFileSettingsWizardPage.this.selectedExtensions.clear();
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    for (Object item : iStructuredSelection) {
                        if (!(item instanceof String)) continue;
                        String extension = (String)item;
                        ExportFileSettingsWizardPage.this.selectedExtensions.add(extension);
                        String description = ExportFileSettingsWizardPage.this.iFileExporter.getDescription(extension);
                        if (description == null) {
                            description = "No description available.";
                        }
                        ExportFileSettingsWizardPage.this.txtDescription.setText(description);
                    }
                }
            }
        });
        TableViewerColumn tableViewerColumnItem_Name1 = new TableViewerColumn(this.toExportExtensionsViewer, 0);
        TableColumn trclmnItemName1 = tableViewerColumnItem_Name1.getColumn();
        trclmnItemName1.setText("Extension");
        trclmnItemName1.setWidth(100);
        this.toExportExtensionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.toExportExtensionsViewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider());
        this.toExportExtensionsViewer.setInput(this.toExportExtensions);
        this.removeButton = new Button(this.container, 8);
        this.removeButton.setText("<-");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportFileSettingsWizardPage.this.toExportExtensions.removeAll(ExportFileSettingsWizardPage.this.selectedExtensions);
                ExportFileSettingsWizardPage.this.availableExtensions.addAll(ExportFileSettingsWizardPage.this.selectedExtensions);
                ExportFileSettingsWizardPage.this.selectedExtensions.clear();
                ExportFileSettingsWizardPage.this.availableExtensionsViewer.setInput((Object)ExportFileSettingsWizardPage.this.availableExtensions);
                ExportFileSettingsWizardPage.this.toExportExtensionsViewer.setInput((Object)ExportFileSettingsWizardPage.this.toExportExtensions);
                ExportFileSettingsWizardPage.this.setPageComplete(!ExportFileSettingsWizardPage.this.toExportExtensions.isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setText("Description :");
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.txtDescription = new Text(this.container, 2);
        GridData txtDescriptionGridData = new GridData(4, 4, true, true, 3, 1);
        txtDescriptionGridData.minimumHeight = 100;
        txtDescriptionGridData.heightHint = 100;
        this.txtDescription.setLayoutData((Object)txtDescriptionGridData);
        this.setControl((Control)this.container);
    }

    public boolean isPageComplete() {
        return !this.toExportExtensions.isEmpty();
    }

    public List<String> getRequestedFileExtension() {
        return this.toExportExtensions;
    }

    private class CustomLabelProvider
    extends ColumnLabelProvider {
        private CustomLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }
}

