/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.ui.wizards;

import java.util.List;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportFileDestinationWizardPage;
import org.eclipse.apogy.common.converters.ui.wizards.ExportFileSettingsWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportToFileWizard
extends Wizard {
    private static final Logger Logger = LoggerFactory.getLogger(ExportToFileWizard.class);
    private final IFileExporter iFileExporter;
    private final Object input;
    private ExportFileSettingsWizardPage pageOne;
    private ExportFileDestinationWizardPage pageTwo;

    public ExportToFileWizard(IFileExporter iFileExporter, Object input) {
        this.setWindowTitle("Export to File");
        this.iFileExporter = iFileExporter;
        this.input = input;
    }

    public boolean canFinish() {
        return this.pageOne.isPageComplete() && this.pageTwo.isPageComplete();
    }

    public boolean performFinish() {
        try {
            this.iFileExporter.exportToFile(this.input, this.pageTwo.getFilePath(), this.pageOne.getRequestedFileExtension());
            return true;
        }
        catch (Throwable t) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error occured during export : " + t.getMessage()));
            Logger.error("Error occured during export.", t);
            return false;
        }
    }

    public List<String> getRequestedExtensions() {
        return this.pageOne.getRequestedFileExtension();
    }

    public void addPages() {
        this.pageOne = new ExportFileSettingsWizardPage("Export Settings", this.iFileExporter, this);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new ExportFileDestinationWizardPage("Export Destination", this.iFileExporter, this);
        this.addPage((IWizardPage)this.pageTwo);
    }
}

