/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersGraphsFacade;
import org.eclipse.apogy.common.converters.ConverterEdge;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.impl.ApogyCommonConvertersFacadeImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonConvertersFacadeCustomImpl
extends ApogyCommonConvertersFacadeImpl {
    public static final String ARROW_STRING = "\u2192";
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonConvertersFacadeImpl.class);
    public static final String CONVERTER_EXTENSION_POINT_ID = "org.eclipse.apogy.common.converters";
    private static final String CONVERTER_EXTENSION_POINT_ID_CLASS = "Class";
    private List<IConverter> converters = null;
    private SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph = null;

    @Override
    public synchronized Object convert(Object input, Class<?> targetType) {
        if (targetType.isAssignableFrom(input.getClass())) {
            return input;
        }
        return ApogyCommonConvertersGraphsFacade.INSTANCE.convert(this.getGraph(), input, targetType);
    }

    @Override
    public synchronized List<IConverter> getAllRegisteredConverters() {
        if (this.converters == null) {
            this.converters = new ArrayList<IConverter>();
            IExtensionPoint nodePresentationExtPoint = Platform.getExtensionRegistry().getExtensionPoint(CONVERTER_EXTENSION_POINT_ID);
            IConfigurationElement[] contributors = nodePresentationExtPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                try {
                    IConverter converter = (IConverter)contributor.createExecutableExtension(CONVERTER_EXTENSION_POINT_ID_CLASS);
                    if (converter != null) {
                        if (converter.getInputType() != null) {
                            if (converter.getOutputType() != null) {
                                this.converters.add(converter);
                            } else {
                                Logger.error("Converter <" + converter.getClass().getName() + "> contributed by <" + contributor.getContributor().getName() + "> has NULL output type.");
                            }
                        } else {
                            Logger.error("Converter <" + converter.getClass().getName() + "> contributed by <" + contributor.getContributor().getName() + "> has NULL input type.");
                        }
                    } else {
                        Logger.error("A NULL converter contributed by <" + contributor.getContributor().getName() + ">.");
                    }
                }
                catch (CoreException e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
        }
        return this.converters;
    }

    @Override
    public synchronized SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> getGraph() {
        if (this.graph == null) {
            this.graph = ApogyCommonConvertersGraphsFacade.INSTANCE.createGraph(this.getAllRegisteredConverters());
            List<IConverter> castConverters = ApogyCommonConvertersGraphsFacade.INSTANCE.generateTypeCastConverters(this.graph);
            ApogyCommonConvertersGraphsFacade.INSTANCE.addConverters(this.graph, castConverters);
        }
        return this.graph;
    }

    @Override
    public IFileExporter getIFileExporter(Object input) {
        return ApogyCommonConvertersGraphsFacade.INSTANCE.findIFileExporter(this.getGraph(), input);
    }
}

