/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToFloatConverter
extends AbstractNumberConverter {
    private static final Logger Logger = LoggerFactory.getLogger(StringToFloatConverter.class);

    public StringToFloatConverter() {
        super(String.class, Float.class);
    }

    public StringToFloatConverter(NumberFormat numberFormat) {
        super(String.class, Float.class);
        this.setNumberFormat(numberFormat);
    }

    public Object convert(Object fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Float(this.getNumberFormat().parse((String)fromObject).floatValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Float((String)fromObject);
    }
}

