/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.PositionMarker;
import org.eclipse.apogy.common.geometry.data3d.impl.RigidBodyPoseTrackerImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigidBodyPoseTrackerCustomImpl
extends RigidBodyPoseTrackerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RigidBodyPoseTrackerImpl.class);

    @Override
    public EList<PositionMarker> getPositionMarkersAtOrigin() {
        if (this.positionMarkersAtOrigin == null) {
            this.positionMarkersAtOrigin = new EObjectResolvingEList(PositionMarker.class, (InternalEObject)this, 0);
        }
        EList localCopy = this.positionMarkersAtOrigin;
        return localCopy;
    }

    @Override
    public Matrix4d computeTransformation(List<PositionMarker> listOfMarkerPositionsToTrack) throws Exception {
        Matrix4d output = new Matrix4d();
        if (listOfMarkerPositionsToTrack.size() < 3) {
            throw new IllegalArgumentException("At least 3 position markers to track are needed");
        }
        if (this.positionMarkersAtOrigin.size() < 3) {
            throw new IllegalArgumentException("At least 3 position markers at origin are needed");
        }
        CartesianCoordinatesSet markerPositionsAtOrigin = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        CartesianCoordinatesSet markerPositionsToTrack = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        CartesianPositionCoordinates tmpPos1 = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        CartesianPositionCoordinates tmpPos2 = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        int i = 0;
        while (i < this.positionMarkersAtOrigin.size()) {
            int j = 0;
            while (j < listOfMarkerPositionsToTrack.size()) {
                if (((PositionMarker)this.positionMarkersAtOrigin.get(i)).getIdentifier() == listOfMarkerPositionsToTrack.get(j).getIdentifier()) {
                    tmpPos1 = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
                    tmpPos1.setX(((PositionMarker)this.positionMarkersAtOrigin.get(i)).getX());
                    tmpPos1.setY(((PositionMarker)this.positionMarkersAtOrigin.get(i)).getY());
                    tmpPos1.setZ(((PositionMarker)this.positionMarkersAtOrigin.get(i)).getZ());
                    markerPositionsAtOrigin.getPoints().add((Object)tmpPos1);
                    tmpPos2 = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
                    tmpPos2.setX(listOfMarkerPositionsToTrack.get(j).getX());
                    tmpPos2.setY(listOfMarkerPositionsToTrack.get(j).getY());
                    tmpPos2.setZ(listOfMarkerPositionsToTrack.get(j).getZ());
                    markerPositionsToTrack.getPoints().add((Object)tmpPos2);
                }
                ++j;
            }
            ++i;
        }
        Matrix homogenousTransformationMatrix = RigidBodyPoseTrackerCustomImpl.compute3DRigidBodyTransformationBetweenTwo3DDatasets(markerPositionsAtOrigin, markerPositionsToTrack);
        int i2 = 0;
        while (i2 <= 3) {
            int j = 0;
            while (j <= 3) {
                output.setElement(i2, j, homogenousTransformationMatrix.get(i2, j));
                ++j;
            }
            ++i2;
        }
        return output;
    }

    @Override
    public void addPositionMarkers(List<PositionMarker> marker) throws Exception {
        if (this.positionMarkersAtOrigin == null) {
            this.positionMarkersAtOrigin = new EObjectResolvingEList(PositionMarker.class, (InternalEObject)this, 0);
        }
        int i = 0;
        while (i < marker.size()) {
            this.positionMarkersAtOrigin.add((Object)marker.get(i));
            ++i;
        }
    }

    @Override
    public void removePositionMarkers(List<PositionMarker> markers) {
        List<PositionMarker> localCopyMarker = markers;
        int i = 0;
        while (i < localCopyMarker.size()) {
            int j = 0;
            while (j < this.positionMarkersAtOrigin.size()) {
                if (localCopyMarker.get(i).getIdentifier() == ((PositionMarker)this.positionMarkersAtOrigin.get(j)).getIdentifier()) {
                    this.positionMarkersAtOrigin.remove(j);
                }
                ++j;
            }
            ++i;
        }
        throw new UnsupportedOperationException();
    }

    private static Matrix compute3DRigidBodyTransformationBetweenTwo3DDatasets(CartesianCoordinatesSet p_0, CartesianCoordinatesSet p) {
        Matrix homogenousTransformationMatrix = new Matrix(4, 4);
        Matrix p_centroid = RigidBodyPoseTrackerCustomImpl.computeCentroidDataSet(p);
        Matrix p_0_centroid = RigidBodyPoseTrackerCustomImpl.computeCentroidDataSet(p_0);
        Matrix rotationMatrix = RigidBodyPoseTrackerCustomImpl.computeRotationMatrixUsingSVD(p_0, p_0_centroid, p, p_centroid);
        Matrix translationMatrix = RigidBodyPoseTrackerCustomImpl.computeTranslationMatrix(rotationMatrix, p_0_centroid, p_centroid);
        homogenousTransformationMatrix.setMatrix(0, 2, 0, 2, rotationMatrix);
        homogenousTransformationMatrix.setMatrix(0, 2, 3, 3, translationMatrix);
        homogenousTransformationMatrix.set(3, 3, 1.0);
        return homogenousTransformationMatrix;
    }

    private static Matrix computeTranslationMatrix(Matrix rotationMatrix, Matrix p_0_centroid, Matrix p_centroid) {
        Matrix translationMatrix = new Matrix(3, 1);
        translationMatrix = p_centroid.minus(rotationMatrix.times(p_0_centroid));
        return translationMatrix;
    }

    private static Matrix computeRotationMatrixUsingSVD(CartesianCoordinatesSet p_0, Matrix P_0_centroid, CartesianCoordinatesSet p, Matrix P_centroid) {
        ArrayList<Matrix> mP_0 = new ArrayList<Matrix>();
        ArrayList<Matrix> mP = new ArrayList<Matrix>();
        Matrix tmpMat3x1 = new Matrix(3, 1);
        int i = 0;
        while (i < p_0.getPoints().size()) {
            tmpMat3x1 = RigidBodyPoseTrackerCustomImpl.convertCartesianCoordinatePositionToMatrix3x1((CartesianPositionCoordinates)p_0.getPoints().get(i));
            tmpMat3x1 = tmpMat3x1.minus(P_0_centroid);
            mP_0.add(tmpMat3x1);
            tmpMat3x1 = RigidBodyPoseTrackerCustomImpl.convertCartesianCoordinatePositionToMatrix3x1((CartesianPositionCoordinates)p.getPoints().get(i));
            tmpMat3x1 = tmpMat3x1.minus(P_centroid);
            mP.add(tmpMat3x1);
            ++i;
        }
        Matrix H = new Matrix(3, 3);
        Matrix tmp3x3 = new Matrix(3, 3);
        int i2 = 0;
        while (i2 < mP.size()) {
            tmp3x3 = ((Matrix)mP_0.get(i2)).times(((Matrix)mP.get(i2)).transpose());
            H = H.plus(tmp3x3);
            ++i2;
        }
        SingularValueDecomposition svg = H.svd();
        Matrix rotationMatrix = new Matrix(3, 3);
        Matrix U = new Matrix(3, 3);
        Matrix V = new Matrix(3, 3);
        U = svg.getU();
        V = svg.getV();
        rotationMatrix = V.times(U.transpose());
        double tol = 1.0E-4;
        if (Math.abs(rotationMatrix.det() + 1.0) < tol) {
            Matrix V_prime = new Matrix(3, 3);
            V_prime = V;
            V_prime.set(0, 2, -1.0 * V.get(0, 2));
            V_prime.set(1, 2, -1.0 * V.get(1, 2));
            V_prime.set(2, 2, -1.0 * V.get(2, 2));
            rotationMatrix = V_prime.times(U.transpose());
        }
        return rotationMatrix;
    }

    private static Matrix computeCentroidDataSet(CartesianCoordinatesSet p) {
        Matrix centroid = new Matrix(3, 1);
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int i = 0;
        while (i < p.getPoints().size()) {
            sumX += ((CartesianPositionCoordinates)p.getPoints().get(i)).getX();
            sumY += ((CartesianPositionCoordinates)p.getPoints().get(i)).getY();
            sumZ += ((CartesianPositionCoordinates)p.getPoints().get(i)).getZ();
            ++i;
        }
        centroid.set(0, 0, sumX / (double)p.getPoints().size());
        centroid.set(1, 0, sumY / (double)p.getPoints().size());
        centroid.set(2, 0, sumZ / (double)p.getPoints().size());
        return centroid;
    }

    private static Matrix convertCartesianCoordinatePositionToMatrix3x1(CartesianPositionCoordinates P) {
        Matrix mP = new Matrix(3, 1);
        mP.set(0, 0, P.getX());
        mP.set(1, 0, P.getY());
        mP.set(2, 0, P.getZ());
        return mP;
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 2: {
                try {
                    return this.computeTransformation((EList<PositionMarker>)((EList)arguments.get(0)));
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            case 0: {
                try {
                    this.addPositionMarkers((List)arguments.get(0));
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
            case 1: {
                this.removePositionMarkers((List)arguments.get(0));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

