/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.impl.TriangularMeshNormalsCalculatorImpl;
import org.eclipse.emf.common.util.EList;

public class TriangularMeshNormalsCalculatorCustomImpl
extends TriangularMeshNormalsCalculatorImpl {
    public CartesianTriangularMesh process(CartesianTriangularMesh input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("input is not specified");
        }
        if (input.getPolygons().size() > 0) {
            input.setNormals(new ArrayList(input.getPoints().size()));
            int i = 0;
            while (i < input.getPoints().size()) {
                Vector3d normal = this.computeNormal(input, i);
                input.getNormals().add(normal);
                ++i;
            }
        }
        return input;
    }

    private Vector3d computeNormal(CartesianTriangularMesh mesh, int pointId) {
        Vector3d normal = new Vector3d(0.0, 0.0, 0.0);
        CartesianPositionCoordinates point = (CartesianPositionCoordinates)mesh.getPoints().get(pointId);
        EList polygons = mesh.getPolygonsSharingPoint(point);
        int n = 0;
        if (polygons.size() >= 0) {
            for (CartesianTriangle triangle : polygons) {
                Vector3d ni = this.computeNormal(point, triangle);
                if (ni == null) continue;
                ++n;
                normal.add((Tuple3d)ni);
            }
        }
        if (n > 1) {
            normal.scale(1.0 / (double)n);
        }
        normal.normalize();
        return normal;
    }

    private Vector3d computeNormal(CartesianPositionCoordinates p0, CartesianTriangle triangle) {
        Vector3d normal = null;
        int p0Index = triangle.getVertices().indexOf((Object)p0);
        if (p0Index != -1) {
            int p1Index = (p0Index + 1) % 3;
            int p2Index = (p0Index + 2) % 3;
            Vector3d p1 = new Vector3d((Tuple3d)((CartesianPositionCoordinates)triangle.getVertices().get(p1Index)).asPoint3d());
            Vector3d p2 = new Vector3d((Tuple3d)((CartesianPositionCoordinates)triangle.getVertices().get(p2Index)).asPoint3d());
            p1.sub((Tuple3d)p0.asPoint3d());
            p2.sub((Tuple3d)p0.asPoint3d());
            normal = new Vector3d();
            normal.cross(p1, p2);
            normal.normalize();
        }
        return normal;
    }
}

