/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.NormalPointCloud;
import org.eclipse.apogy.common.geometry.data3d.TriangularMeshNormalsCalculator;
import org.eclipse.apogy.common.geometry.data3d.impl.TriangularMeshToNormalPointCloudImpl;

public class TriangularMeshToNormalPointCloudCustomImpl
extends TriangularMeshToNormalPointCloudImpl {
    public NormalPointCloud process(CartesianTriangularMesh input) throws Exception {
        NormalPointCloud output = ApogyCommonGeometryData3DFactory.eINSTANCE.createNormalPointCloud();
        ArrayList<Vector3d> normals = null;
        ArrayList<Point3d> points = new ArrayList<Point3d>(input.getPoints().size());
        for (CartesianPositionCoordinates point : input.getPoints()) {
            points.add(point.asPoint3d());
        }
        if (input.getNormals() == null || input.getNormals().size() != input.getPoints().size()) {
            TriangularMeshNormalsCalculator normalsCalculator = ApogyCommonGeometryData3DFactory.eINSTANCE.createTriangularMeshNormalsCalculator();
            input = (CartesianTriangularMesh)normalsCalculator.process(input);
        }
        if (input.getNormals() != null && input.getNormals().size() > 0) {
            normals = new ArrayList<Vector3d>(input.getNormals().size());
            for (Vector3d normal : input.getNormals()) {
                normals.add(new Vector3d(normal));
            }
        }
        output.setPoints(points);
        output.setNormals(normals);
        return output;
    }
}

