/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.io.jinput.ui.composites;

import java.util.Arrays;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.io.jinput.Activator;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputFacade;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputPackage;
import org.eclipse.apogy.common.io.jinput.EComponentQualifier;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AutomaticControllerSelectionComposite
extends Composite {
    final String CLICK_PROMPT = "Click here to bind the controller";
    private final Text controllerText;
    private final Text componentText;
    private boolean selectionStarted = false;
    private Listener listener;
    private EComponentQualifier eComponentQualifier;
    private String initialControllerName;
    private String initialComponentName;
    private DataBindingContext m_bindingContext;

    public AutomaticControllerSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (AutomaticControllerSelectionComposite.this.selectionStarted) {
                    AutomaticControllerSelectionComposite.this.stopSelection();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Label controllerLabel = new Label((Composite)this, 0);
        controllerLabel.setText("Controller : ");
        controllerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.controllerText = new Text((Composite)this, 2048);
        this.controllerText.setText("Click here to bind the controller");
        this.controllerText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.controllerText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!AutomaticControllerSelectionComposite.this.selectionStarted) {
                    AutomaticControllerSelectionComposite.this.startSelection();
                }
            }
        });
        this.controllerText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (AutomaticControllerSelectionComposite.this.selectionStarted) {
                    AutomaticControllerSelectionComposite.this.stopSelection();
                }
            }
        });
        Label componentLabel = new Label((Composite)this, 0);
        componentLabel.setText("Component : ");
        componentLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.componentText = new Text((Composite)this, 2048);
        this.componentText.setText("Click here to bind the controller");
        this.componentText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.componentText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!AutomaticControllerSelectionComposite.this.selectionStarted) {
                    AutomaticControllerSelectionComposite.this.startSelection();
                }
            }
        });
        this.componentText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (AutomaticControllerSelectionComposite.this.selectionStarted) {
                    AutomaticControllerSelectionComposite.this.stopSelection();
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AutomaticControllerSelectionComposite.this.m_bindingContext != null) {
                    AutomaticControllerSelectionComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    private void startSelection() {
        if (!ApogyCommonIOJInputFacade.INSTANCE.isSelectingComponent()) {
            this.selectionStarted = true;
            if (this.eComponentQualifier != null) {
                this.initialControllerName = this.eComponentQualifier.getEControllerName();
                this.initialComponentName = this.eComponentQualifier.getEComponentName();
            }
            ApogyCommonIOJInputFacade.INSTANCE.startSelectComponent(this.eComponentQualifier);
        }
        this.controllerText.setBackground(this.getTextsBackgroundColor());
        this.componentText.setBackground(this.getTextsBackgroundColor());
        List<Listener> listeners = Arrays.asList(this.getShell().getListeners(31));
        for (Listener listener : listeners) {
            this.getShell().removeListener(31, listener);
        }
        this.getShell().addListener(31, this.getListener());
        for (Listener listener : listeners) {
            this.getShell().addListener(31, listener);
        }
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2 || event.detail == 4) {
                        AutomaticControllerSelectionComposite.this.stopSelection();
                        if (event.detail == 2 && AutomaticControllerSelectionComposite.this.eComponentQualifier != null) {
                            if (ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)AutomaticControllerSelectionComposite.this.eComponentQualifier) != null) {
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AutomaticControllerSelectionComposite.this.eComponentQualifier, (EStructuralFeature)ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECONTROLLER_NAME, (Object)AutomaticControllerSelectionComposite.this.initialControllerName);
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AutomaticControllerSelectionComposite.this.eComponentQualifier, (EStructuralFeature)ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECOMPONENT_NAME, (Object)AutomaticControllerSelectionComposite.this.initialComponentName);
                            } else {
                                AutomaticControllerSelectionComposite.this.eComponentQualifier.setEControllerName(AutomaticControllerSelectionComposite.this.initialControllerName);
                                AutomaticControllerSelectionComposite.this.eComponentQualifier.setEComponentName(AutomaticControllerSelectionComposite.this.initialComponentName);
                            }
                        }
                        event.doit = false;
                    }
                }
            };
        }
        return this.listener;
    }

    private void stopSelection() {
        ApogyCommonIOJInputFacade.INSTANCE.stopSelectComponent(this.eComponentQualifier);
        this.selectionStarted = false;
        this.controllerText.setBackground(this.getTextsBackgroundColor());
        this.componentText.setBackground(this.getTextsBackgroundColor());
        this.newSelection(null);
        this.getShell().removeListener(31, this.getListener());
    }

    public void setEComponentQualifier(EComponentQualifier eComponentQualifier) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.eComponentQualifier = eComponentQualifier;
        if (eComponentQualifier != null) {
            this.initDataBindingsCustom();
            if (eComponentQualifier.getEControllerName() != null) {
                this.controllerText.setText(eComponentQualifier.getEControllerName());
            }
            if (eComponentQualifier.getEComponentName() != null) {
                this.componentText.setText(eComponentQualifier.getEComponentName());
            }
        }
        this.controllerText.setBackground(this.getTextsBackgroundColor());
        this.componentText.setBackground(this.getTextsBackgroundColor());
    }

    protected void newSelection(ISelection selection) {
    }

    private Color getTextsBackgroundColor() {
        if (this.selectionStarted) {
            return Display.getCurrent().getSystemColor(7);
        }
        if (Activator.getEControllerEnvironment().resolveEComponent(this.eComponentQualifier) != null) {
            return Display.getCurrent().getSystemColor(5);
        }
        return Display.getCurrent().getSystemColor(3);
    }

    protected DataBindingContext initDataBindingsCustom() {
        this.m_bindingContext = new DataBindingContext();
        IObservableValue observeEComponentQualifierControllerName = EMFProperties.value((EStructuralFeature)ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECONTROLLER_NAME).observe((Object)this.eComponentQualifier);
        ISWTObservableValue observeControllerTextText = WidgetProperties.text().observe((Widget)this.controllerText);
        ISWTObservableValue observeControllerTextBackground = WidgetProperties.background().observe((Widget)this.controllerText);
        this.m_bindingContext.bindValue((IObservableValue)observeControllerTextText, observeEComponentQualifierControllerName, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                AutomaticControllerSelectionComposite.this.newSelection(null);
                return fromObject == null ? "Click here to bind the controller" : fromObject;
            }
        }));
        this.m_bindingContext.bindValue((IObservableValue)observeControllerTextBackground, observeEComponentQualifierControllerName, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                return AutomaticControllerSelectionComposite.this.getTextsBackgroundColor();
            }
        }));
        IObservableValue observeEComponentQualifierComponentName = EMFProperties.value((EStructuralFeature)ApogyCommonIOJInputPackage.Literals.ECOMPONENT_QUALIFIER__ECOMPONENT_NAME).observe((Object)this.eComponentQualifier);
        ISWTObservableValue observeComponentTextText = WidgetProperties.text().observe((Widget)this.componentText);
        ISWTObservableValue observeComponentTextBackground = WidgetProperties.background().observe((Widget)this.controllerText);
        this.m_bindingContext.bindValue((IObservableValue)observeComponentTextText, observeEComponentQualifierComponentName, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                AutomaticControllerSelectionComposite.this.newSelection(null);
                return fromObject == null ? "Click here to bind the controller" : fromObject;
            }
        }));
        this.m_bindingContext.bindValue((IObservableValue)observeComponentTextBackground, observeEComponentQualifierComponentName, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                return AutomaticControllerSelectionComposite.this.getTextsBackgroundColor();
            }
        }));
        return this.m_bindingContext;
    }
}

