/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.wizards;

import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.bindings.FeatureRootsList;
import org.eclipse.apogy.common.topology.bindings.ui.dialogs.AbstractFeatureNodeSelectionDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AbstractTopologyBindingWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.bindings.ui.wizards.AbstractTopologyBindingWizardPage";
    private AbstractTopologyBinding abstractTopologyBinding;
    private FeatureRootsList featureRootsList;
    private Class featureSuperClass = null;
    private Adapter adapter;
    private DataBindingContext m_bindingContext;
    private EditingDomain editingDomain;
    private Text nameText;
    private StyledText descriptionText;
    private Text featureNodeText;
    private Button selectFeatureButton;

    public AbstractTopologyBindingWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Name and Description");
        this.setDescription("Enter a name and a description (optional).");
    }

    public AbstractTopologyBindingWizardPage(FeatureRootsList featureRootsList, AbstractTopologyBinding abstractTopologyBinding) {
        this();
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)abstractTopologyBinding);
        this.abstractTopologyBinding = abstractTopologyBinding;
        this.featureRootsList = featureRootsList;
        this.featureSuperClass = abstractTopologyBinding.getSupportedFeatureType();
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText("Name : ");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblDescription = new Label(container, 0);
        lblDescription.setText("Description : ");
        lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.descriptionText = new StyledText(container, 2816);
        this.descriptionText.setAlwaysShowScrollBars(false);
        GridData gd_descriptionText = new GridData(4, 4, true, false, 2, 1);
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        Label lblFeature = new Label(container, 0);
        lblFeature.setText("Abstract Feature Node : ");
        lblFeature.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.featureNodeText = new Text(container, 2048);
        this.featureNodeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.featureNodeText.setEditable(false);
        this.selectFeatureButton = new Button(container, 8);
        this.selectFeatureButton.setText("Select");
        this.selectFeatureButton.setToolTipText("Select the Feature this Binding if related to.");
        this.selectFeatureButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AbstractFeatureNodeSelectionDialog dialog = new AbstractFeatureNodeSelectionDialog(AbstractTopologyBindingWizardPage.this.getShell(), AbstractTopologyBindingWizardPage.this.featureRootsList, AbstractTopologyBindingWizardPage.this.featureSuperClass);
                dialog.open();
                AbstractFeatureNode selectedAbstractFeatureNode = dialog.getSelectedAbstractFeatureNode();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AbstractTopologyBindingWizardPage.this.abstractTopologyBinding, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__FEATURE_NODE, (Object)selectedAbstractFeatureNode);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setControl((Control)container);
        if (this.abstractTopologyBinding != null) {
            this.abstractTopologyBinding.eAdapters().add((Object)this.getAdapter());
        }
        this.validate();
        this.m_bindingContext = this.initCustomDataBindings();
    }

    public void dispose() {
        super.dispose();
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.abstractTopologyBinding != null) {
            this.abstractTopologyBinding.eAdapters().remove((Object)this.getAdapter());
        }
    }

    protected void validate() {
        String errorStr = null;
        String infoStr = null;
        if (this.abstractTopologyBinding.getName() == null || this.abstractTopologyBinding.getName().isEmpty()) {
            errorStr = "A name must be provided.";
        } else if (this.abstractTopologyBinding.getFeatureNode() == null) {
            errorStr = "A feature must be selected.";
        }
        this.setMessage(infoStr);
        this.setErrorMessage(errorStr);
        this.setPageComplete(errorStr == null);
    }

    private DataBindingContext initCustomDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue nameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.nameText);
        IObservableValue nameObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__NAME).observe((Object)this.abstractTopologyBinding) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__NAME).observe((Object)this.abstractTopologyBinding);
        bindingContext.bindValue((IObservableValue)nameObserveWidget, nameObserveValue, null, null);
        ISWTObservableValue descriptionObserveWidget = WidgetProperties.text((int[])new int[]{24, 16, 14}).observeDelayed(500, (Widget)this.descriptionText);
        IObservableValue descriptionObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__DESCRIPTION).observe((Object)this.abstractTopologyBinding) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__DESCRIPTION).observe((Object)this.abstractTopologyBinding);
        bindingContext.bindValue((IObservableValue)descriptionObserveWidget, descriptionObserveValue, null, null);
        ISWTObservableValue featureObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.featureNodeText);
        IObservableValue featureObserveValue = this.editingDomain == null ? EMFProperties.value((EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__FEATURE_NODE).observe((Object)this.abstractTopologyBinding) : EMFEditProperties.value((EditingDomain)this.editingDomain, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ABSTRACT_TOPOLOGY_BINDING__FEATURE_NODE).observe((Object)this.abstractTopologyBinding);
        bindingContext.bindValue((IObservableValue)featureObserveWidget, featureObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(AbstractFeatureNode.class, String.class){

            public Object convert(Object arg0) {
                if (arg0 instanceof AbstractFeatureNode) {
                    AbstractFeatureNode node = (AbstractFeatureNode)arg0;
                    return ApogyCommonEMFFacade.INSTANCE.getAncestriesString(node);
                }
                return null;
            }
        }));
        return bindingContext;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AbstractTopologyBindingWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }
}

