/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.wizards;

import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.Axis;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AxisSelectionWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.bindings.ui.wizards.AxisSelectionWizardPage";
    protected AbstractTopologyBinding abstractTopologyBinding;
    private Axis selectedAxis;
    private ComboViewer comboViewer;

    public AxisSelectionWizardPage(String title, String description, AbstractTopologyBinding abstractTopologyBinding) {
        super(WIZARD_PAGE_ID);
        this.setTitle(title);
        this.setDescription(description);
        this.abstractTopologyBinding = abstractTopologyBinding;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblAxis = new Label(container, 0);
        lblAxis.setText("Axis : ");
        this.comboViewer = this.createCombo(container, 0);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    AxisSelectionWizardPage.this.selectedAxis = null;
                    AxisSelectionWizardPage.this.axisSelected(AxisSelectionWizardPage.this.selectedAxis);
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof Axis) {
                        AxisSelectionWizardPage.this.selectedAxis = (Axis)iStructuredSelection.getFirstElement();
                    } else {
                        AxisSelectionWizardPage.this.selectedAxis = null;
                    }
                    AxisSelectionWizardPage.this.axisSelected(AxisSelectionWizardPage.this.selectedAxis);
                }
                AxisSelectionWizardPage.this.validate();
            }
        });
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)Axis.XAXIS));
        this.setControl((Control)container);
        this.validate();
    }

    public Axis getSelectedAxis() {
        return this.selectedAxis;
    }

    protected abstract void axisSelected(Axis var1);

    protected void validate() {
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 12);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Axis) {
                    Axis axis = (Axis)element;
                    return axis.getLiteral();
                }
                return "";
            }
        });
        comboViewer.setInput((Object)Axis.VALUES);
        return comboViewer;
    }
}

